/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.core.util.CommonLabels;

public record UnitFormat(int decimalPlaces, double multiplier, Component suffix, RoundingMode roundingMode) {
    public static final UnitFormat IDENTITY = new UnitFormat(0, 1.0, CommonComponents.EMPTY, RoundingMode.NORMAL);
    public static final UnitFormat PERCENT = new UnitFormat(2, 100.0, (Component)Component.literal((String)"%"), RoundingMode.NORMAL);
    public static final Codec<UnitFormat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("decimalPlaces", (Object)2).forGetter(UnitFormat::decimalPlaces), (App)Codec.DOUBLE.optionalFieldOf("multiplier", (Object)1.0).forGetter(UnitFormat::multiplier), (App)ComponentSerialization.CODEC.optionalFieldOf("suffix", (Object)CommonComponents.EMPTY).forGetter(UnitFormat::suffix), (App)Codecs.enumCodec(RoundingMode.class).optionalFieldOf("roundingMode", (Object)RoundingMode.NORMAL).forGetter(UnitFormat::roundingMode)).apply((Applicative)instance, UnitFormat::new));

    public String format(double value) {
        if (Double.isNaN(value)) {
            return CommonLabels.NOT_AVAILABLE_SHORT.getString();
        }
        if (this.decimalPlaces == 0) {
            return String.format(Locale.ROOT, "%d%s", (int)this.roundingMode.applyAsDouble(value * this.multiplier), this.suffix.getString());
        }
        String format = "%." + this.decimalPlaces + "f%s";
        return String.format(Locale.ROOT, format, value * this.multiplier, this.suffix.getString());
    }

    public static enum RoundingMode implements DoubleUnaryOperator
    {
        DOWN(Mth::floor),
        NORMAL(Math::round),
        UP(Mth::ceil);

        private final DoubleUnaryOperator operator;

        private RoundingMode(DoubleUnaryOperator operator) {
            this.operator = operator;
        }

        @Override
        public double applyAsDouble(double operand) {
            return this.operator.applyAsDouble(operand);
        }
    }
}

