/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.armor;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.damagesource.IReductionFunction;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.commons.lang3.mutable.MutableFloat;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.medsystem.common.armor.ArmorComponent;
import tnt.tarkovcraft.medsystem.common.armor.ForcedReductionFunction;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.LimbType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;

public class ModularArmorComponent
implements ArmorComponent {
    private final float armorValueMultiplier;

    protected ModularArmorComponent(float armorValueMultiplier) {
        this.armorValueMultiplier = armorValueMultiplier;
    }

    @Override
    public boolean shouldDeflectIncomingHit(DamageSource source, LivingEntity entity, List<HitResult> hits) {
        return false;
    }

    @Override
    public void applyItemDamage(ArmorHurtEvent event, DamageContext context) {
        LivingEntity entity = event.getEntity();
        HashSet<EquipmentSlot> hitSlots = new HashSet<EquipmentSlot>(context.getAffectedSlots());
        HashSet armorSlots = new HashSet(event.getArmorMap().keySet());
        Map map = event.getArmorMap();
        float damageReductionMultiplier = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.ARMOR_DURABILITY, (float)1.0f);
        for (EquipmentSlot slot : armorSlots) {
            if (!hitSlots.contains(slot)) {
                map.remove(slot);
                continue;
            }
            float damage = event.getNewDamage(slot).floatValue();
            if (!(damage > 0.0f) || damageReductionMultiplier == 1.0f) continue;
            event.setNewDamage(slot, Math.max(damage * damageReductionMultiplier, 1.0f));
        }
    }

    @Override
    public void applyDamageReduction(LivingIncomingDamageEvent event, DamageContext context) {
        float enchantment;
        LivingEntity entity = event.getEntity();
        Limb limb = context.getHits().stream().map(HitResult::limb).findFirst().orElse(null);
        if (limb == null) {
            return;
        }
        LimbType type = limb.getType();
        DamageSource source = event.getSource();
        Set<EquipmentSlot> slots = type.getArmorSlots();
        MutableFloat armorValue = new MutableFloat(0.0f);
        MutableFloat enchantmentValue = new MutableFloat(0.0f);
        this.calculateReductions(slots, context, entity, armorValue, enchantmentValue);
        float toughness = (float)entity.getAttributeValue(Attributes.ARMOR_TOUGHNESS);
        float damageAfterAbsorb = CombatRules.getDamageAfterAbsorb((LivingEntity)entity, (float)event.getAmount(), (DamageSource)context.getSource(), (float)(armorValue.floatValue() * this.armorValueMultiplier), (float)toughness);
        float armorReduction = event.getAmount() - damageAfterAbsorb;
        if (armorReduction > 0.0f) {
            event.addReductionModifier(DamageContainer.Reduction.ARMOR, (IReductionFunction)new ForcedReductionFunction(armorReduction));
        }
        float f = enchantment = source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) || source.is(DamageTypeTags.BYPASSES_EFFECTS) ? 0.0f : enchantmentValue.floatValue();
        if (enchantment > 0.0f) {
            float enchantAdjustedDamage = CombatRules.getDamageAfterMagicAbsorb((float)event.getAmount(), (float)enchantment);
            float enchantReduction = event.getAmount() - enchantAdjustedDamage;
            if (enchantReduction > 0.0f) {
                event.addReductionModifier(DamageContainer.Reduction.ENCHANTMENTS, (IReductionFunction)new ForcedReductionFunction(enchantReduction));
            }
        }
    }

    protected void calculateReductions(Collection<EquipmentSlot> slots, DamageContext ctx, LivingEntity entity, MutableFloat armor, MutableFloat enchants) {
        double armorAttribute = entity.getAttribute(Attributes.ARMOR).getBaseValue();
        for (EquipmentSlot slot : slots) {
            ItemStack itemStack = entity.getItemBySlot(slot);
            if (itemStack.isEmpty()) continue;
            ctx.getAffectedSlots().add(slot);
            ItemAttributeModifiers modifiers = itemStack.getAttributeModifiers();
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                AttributeModifier modifier;
                if (!entry.attribute().is(Attributes.ARMOR) || (modifier = entry.modifier()).operation() != AttributeModifier.Operation.ADD_VALUE) continue;
                armorAttribute += modifier.amount();
            }
            EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (EquipmentSlot)slot, (LivingEntity)entity, (enchantment, enchLevel, enchantedItem) -> ((Enchantment)enchantment.value()).modifyDamageProtection((ServerLevel)entity.level(), enchLevel, enchantedItem.itemStack(), (Entity)entity, ctx.getSource(), enchants));
        }
        armor.setValue((Number)armorAttribute);
    }
}

