/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.client.IconWithLabel;

public class PlayerProfileLabelContainer {
    public static final ResourceLocation ROW_PLAYER_NAME = TarkovCraftCore.createResourceLocation("profile_name");
    public static final ResourceLocation ROW_STAT = TarkovCraftCore.createResourceLocation("stat");
    public static final ResourceLocation ROW_STAT_SEPARATOR = TarkovCraftCore.createResourceLocation("separator/status");
    private final List<ProfileLabelRow> rows = new ArrayList<ProfileLabelRow>();

    public void addRow(ProfileLabelRow row) {
        this.rows.add(row);
    }

    public void addEmptyRow(ResourceLocation rowId) {
        this.addRow(new ProfileLabelRow(rowId, null, null, null));
    }

    @Nullable
    public ProfileLabelRow findRow(ResourceLocation rowIdentifier) {
        return this.rows.stream().filter(row -> row.identifier().equals((Object)rowIdentifier)).findFirst().orElse(null);
    }

    public boolean replaceOrDeleteRow(ResourceLocation identifier, UnaryOperator<ProfileLabelRow> replacement) {
        for (int i = 0; i < this.rows.size(); ++i) {
            ProfileLabelRow row = this.rows.get(i);
            ProfileLabelRow newRow = (ProfileLabelRow)replacement.apply(row);
            if (!row.identifier().equals((Object)identifier)) continue;
            if (newRow == null) {
                this.rows.remove(i);
            } else {
                this.rows.set(i, newRow);
            }
            return true;
        }
        return false;
    }

    public List<ProfileLabelRow> getRows() {
        return ImmutableList.copyOf(this.rows);
    }

    public record ProfileLabelRow(ResourceLocation identifier, @Nullable IconWithLabel left, @Nullable IconWithLabel center, @Nullable IconWithLabel right) {
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ProfileLabelRow)) {
                return false;
            }
            ProfileLabelRow that = (ProfileLabelRow)o;
            return Objects.equals(this.identifier, that.identifier);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.identifier);
        }

        public static ProfileLabelRow left(ResourceLocation identifier, IconWithLabel left) {
            return new ProfileLabelRow(identifier, left, null, null);
        }

        public static ProfileLabelRow center(ResourceLocation identifier, IconWithLabel center) {
            return new ProfileLabelRow(identifier, null, center, null);
        }

        public static ProfileLabelRow right(ResourceLocation identifier, IconWithLabel right) {
            return new ProfileLabelRow(identifier, null, null, right);
        }
    }
}

