/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.data.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;
import tnt.tarkovcraft.core.common.init.CoreNumberProviders;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.core.util.NumberOperator;

public class OperandNumberProvider
implements NumberProvider {
    public static final MapCodec<OperandNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviderType.complexCodec(Codec.DOUBLE).listOf(2, Integer.MAX_VALUE).fieldOf("values").forGetter(t -> {
        List<NumberProvider> values = t.values;
        ArrayList list = new ArrayList();
        values.forEach(prov -> list.add(Either.left((Object)prov)));
        return list;
    }), (App)Codecs.enumCodec(NumberOperator.class).fieldOf("operator").forGetter(t -> t.operator)).apply((Applicative)instance, OperandNumberProvider::new));
    private final List<NumberProvider> values;
    private final NumberOperator operator;

    public OperandNumberProvider(List<Either<NumberProvider, Either<Duration, Double>>> values, NumberOperator operator) {
        this.values = values.stream().map(NumberProviderType::resolve).toList();
        this.operator = operator;
    }

    @Override
    public double getNumber() {
        double identity = this.values.getFirst().getNumber();
        return this.values.stream().skip(1L).mapToDouble(NumberProvider::getNumber).reduce(identity, this.operator);
    }

    @Override
    public NumberProviderType<?> getType() {
        return CoreNumberProviders.OPERAND.get();
    }
}

