/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.mail;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.api.event.MailEvent;
import tnt.tarkovcraft.core.common.config.TarkovCraftCoreConfig;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.mail.MailManager;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.network.message.S2C_SendDataAttachments;

public final class MailSystem {
    public static final Marker MARKER = MarkerManager.getMarker((String)"MailSystem");
    public static final Component FAILED_TO_SEND_MESSAGE = Component.translatable((String)"label.tarkovcraft_core.mail.failed_to_send_message");

    public static boolean isEnabled() {
        return TarkovCraftCore.getConfig().enableMailSystem;
    }

    public static boolean isCommandAllowed(CommandSourceStack stack) {
        TarkovCraftCoreConfig config = TarkovCraftCore.getConfig();
        if (!config.enableMailSystem) {
            return false;
        }
        ServerPlayer player = stack.getPlayer();
        return player == null || config.allowMailPlayerMessages;
    }

    public static void sendMessage(Player target, MailSource source, MailMessage message) {
        Level level = target.level();
        if (level.isClientSide() || message.isBlank()) {
            return;
        }
        if (!MailSystem.isEnabled()) {
            TarkovCraftCore.LOGGER.warn(MARKER, "Attempted to send mail to player {} while having disabled mail system! No message will be sent", (Object)target);
            return;
        }
        if (!TarkovCraftCore.getConfig().allowMailPlayerMessages && !source.isSystemChat()) {
            TarkovCraftCore.LOGGER.warn(MARKER, "Player {} tried to send chat message to {} while chat messages were disabled!", (Object)source.getName().getString(), (Object)target.getDisplayName().getString());
            return;
        }
        if (message.isExpired()) {
            TarkovCraftCore.LOGGER.warn(MARKER, "Attempted to send expired message to {}", (Object)target);
            return;
        }
        if (source.is((Entity)target)) {
            TarkovCraftCore.LOGGER.warn(MARKER, "Player {} attempted to send message to themselves. Ignoring request", (Object)target);
            return;
        }
        MailSource targetChat = MailSource.player(target);
        if (MailSystem.canSendMessage(level, message, source, targetChat)) {
            if (!source.isSystemChat()) {
                ServerPlayer sender = level.getServer().getPlayerList().getPlayer(source.getSourceId());
                if (sender == null) {
                    TarkovCraftCore.LOGGER.error(MARKER, "Failed to send message due to missing sender playerID {}", (Object)source.getSourceId());
                    return;
                }
                ((MailManager)sender.getData(CoreDataAttachments.MAIL_MANAGER)).sendMessage(targetChat, message);
                PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)sender, CoreDataAttachments.MAIL_MANAGER.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            MailManager targetManager = (MailManager)target.getData(CoreDataAttachments.MAIL_MANAGER);
            boolean isBlocked = targetManager.isBlocked(source);
            NeoForge.EVENT_BUS.post((Event)new MailEvent.OnMailReceiveAttempt(message, source, targetChat, targetManager, level, isBlocked));
            if (!isBlocked) {
                targetManager.receiveMessage(source, message);
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)target), (CustomPacketPayload)new S2C_SendDataAttachments((Entity)target, CoreDataAttachments.MAIL_MANAGER.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static boolean canSendMessage(Level level, MailMessage message, MailSource source, MailSource destination) {
        MailEvent.MailSendingEvent event = (MailEvent.MailSendingEvent)NeoForge.EVENT_BUS.post((Event)new MailEvent.MailSendingEvent(level, message, source, destination));
        return !event.isCanceled();
    }
}

