/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import tnt.tarkovcraft.core.client.util.ClientUtils;
import tnt.tarkovcraft.core.common.Notification;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.skill.Skill;
import tnt.tarkovcraft.core.common.skill.SkillContext;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.stat.SkillStat;
import tnt.tarkovcraft.core.common.skill.stat.SkillStatDefinition;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTriggerEvent;
import tnt.tarkovcraft.core.network.Synchronizable;
import tnt.tarkovcraft.core.network.message.S2C_SendDataAttachments;

public final class SkillData
implements Synchronizable<SkillData> {
    public static final MapCodec<SkillData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Skill.CODEC.listOf().fieldOf("skills").xmap(SkillData::asSkillMap, map -> new ArrayList(map.values())).forGetter(t -> t.skillMap)).apply((Applicative)instance, SkillData::new));
    public static final Codec<SkillData> CODEC = MAP_CODEC.codec();
    private Entity holder;
    private final Map<SkillDefinition, Skill> skillMap;

    public SkillData(IAttachmentHolder holder) {
        this.skillMap = new HashMap<SkillDefinition, Skill>();
        this.setHolder(holder);
    }

    private SkillData(Map<SkillDefinition, Skill> map) {
        this.skillMap = new HashMap<SkillDefinition, Skill>(map);
    }

    public void setHolder(IAttachmentHolder holder) {
        if (!(holder instanceof Entity)) {
            throw new IllegalArgumentException("Holder must be an instance of Entity");
        }
        Entity entity = (Entity)holder;
        this.holder = entity;
    }

    public boolean trigger(SkillTriggerEvent event, SkillDefinition definition, float multiplier, Entity triggerSource) {
        SkillContext context;
        Skill instance = this.getSkill(definition);
        float triggerAmount = instance.trigger(context = new SkillContext(event, definition, instance, multiplier, triggerSource));
        if (triggerAmount > 0.0f) {
            EntityAttributeData attributes = (EntityAttributeData)triggerSource.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
            float experience = triggerAmount * this.getGroupLevelMultiplier(attributes, definition.getGroupLevelingModifiers());
            long gameTime = triggerSource.level().getGameTime();
            instance.updateMemory(gameTime, attributes, prevLevel -> this.onLevelChange(prevLevel, instance));
            this.addExperience(instance, experience);
            return true;
        }
        return false;
    }

    public void addExperience(SkillDefinition definition, float experience) {
        Skill instance = this.getSkill(definition);
        this.addExperience(instance, experience);
    }

    public void addExperience(Skill instance, float experience) {
        instance.addExperience(experience, previousLevel -> this.onLevelChange(previousLevel, instance));
    }

    public Skill getSkill(SkillDefinition skill) {
        return this.skillMap.computeIfAbsent(skill, this::createInstance);
    }

    @Override
    public Codec<SkillData> networkCodec() {
        return CODEC;
    }

    @Override
    public void preSyncPrepare() {
        this.applyStats();
    }

    public void reloadStats() {
        for (Map.Entry<SkillDefinition, Skill> entry : this.skillMap.entrySet()) {
            SkillDefinition definition = entry.getKey();
            Skill instance = entry.getValue();
            List<SkillStatDefinition> stats = definition.getStats();
            stats.forEach(statDef -> statDef.stat().clear(definition, instance, this.holder));
            this.applyStats(definition, instance);
        }
    }

    private void applyStats() {
        for (Map.Entry<SkillDefinition, Skill> entry : this.skillMap.entrySet()) {
            SkillDefinition definition = entry.getKey();
            Skill instance = entry.getValue();
            this.applyStats(definition, instance);
        }
    }

    private void applyStats(SkillDefinition definition, Skill skill) {
        for (SkillStatDefinition statDefinition : definition.getStats()) {
            if (!statDefinition.isAvailable(definition, skill, this.holder)) continue;
            SkillStat stat = statDefinition.stat();
            stat.apply(definition, skill, this.holder);
        }
    }

    private Skill createInstance(SkillDefinition definition) {
        Skill instance = definition.instance(this.getRegistryAccess());
        if (this.holder != null) {
            this.applyStats(definition, instance);
        }
        return instance;
    }

    private static Map<SkillDefinition, Skill> asSkillMap(List<Skill> list) {
        return list.stream().collect(Collectors.toMap(skill -> (SkillDefinition)skill.getDefinition().value(), Function.identity()));
    }

    private RegistryAccess getRegistryAccess() {
        if (this.holder == null || this.holder.level().isClientSide()) {
            return ClientUtils.getClientRegistryAccess();
        }
        return this.holder.registryAccess();
    }

    private float getGroupLevelMultiplier(EntityAttributeData data, List<Holder<Attribute>> group) {
        float multiplier = 1.0f;
        for (Holder<Attribute> holder : group) {
            float attributeValue = data.getAttribute(holder).floatValue();
            multiplier *= attributeValue;
        }
        return Math.max(0.0f, multiplier);
    }

    public void onLevelChange(int prevLevel, Skill skill) {
        Entity entity = this.holder;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (prevLevel < skill.getLevel()) {
                Holder<SkillDefinition> definitionHolder = skill.getDefinition();
                SkillDefinition definition = (SkillDefinition)definitionHolder.value();
                Notification notification = Notification.success((Component)Component.translatable((String)"label.tarkovcraft_core.skill.level_up", (Object[])new Object[]{definition.getName(), skill.getLevel()}));
                notification.setIcon(SkillDefinition.getIcon(definitionHolder));
                notification.send(player);
            }
            this.applyStats();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.SKILL.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

