/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.util.Codecs;

public record HealthRecovery(int cycleDuration, float healthPerCycle, int maxCycles) implements TooltipProvider
{
    public static final Codec<HealthRecovery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("cycleTime", (Object)20).forGetter(HealthRecovery::cycleDuration), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("healAmount").forGetter(HealthRecovery::healthPerCycle), (App)Codecs.NON_NEGATIVE_INT.optionalFieldOf("maxCycles", (Object)1).forGetter(HealthRecovery::maxCycles)).apply((Applicative)instance, HealthRecovery::new));

    public int getMaxUseDuration(int itemLimit) {
        return this.maxCycles > 0 ? this.maxCycles * this.cycleDuration : itemLimit;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        MutableComponent healthPoints = Component.literal((String)String.format(Locale.ROOT, "%.1f", Float.valueOf(this.healthPerCycle))).withStyle(ChatFormatting.GREEN);
        MutableComponent duration = Duration.format((int)this.cycleDuration).copy().withStyle(ChatFormatting.GREEN);
        if (this.maxCycles > 0) {
            MutableComponent healLimit = Component.literal((String)String.format(Locale.ROOT, "%.1f", Float.valueOf(this.healthPerCycle * (float)this.maxCycles))).withStyle(ChatFormatting.YELLOW);
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.heal.limited", (Object[])new Object[]{healthPoints, duration, healLimit}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.heal.infinite", (Object[])new Object[]{healthPoints, duration}).withStyle(ChatFormatting.GRAY));
        }
    }
}

