/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.overlay;

import com.mojang.blaze3d.platform.Window;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.joml.Vector2f;
import org.joml.Vector4f;
import tnt.tarkovcraft.core.util.helper.RenderUtils;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.config.HealthOverlayConfiguration;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;

public class HealthLayer
implements GuiLayer {
    public static final ResourceLocation LAYER_ID = MedicalSystem.resource("layer/health");

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        HealthOverlayConfiguration overlay = MedicalSystemClient.getConfig().healthOverlay;
        if (!overlay.enabled) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        Entity camera = client.cameraEntity;
        if (camera == null || client.options.hideGui) {
            return;
        }
        if (player.isSpectator() && player == camera) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        Window window = client.getWindow();
        if (!HealthSystem.hasCustomHealth(camera)) {
            return;
        }
        float scale = overlay.scale;
        float overlayWidth = 60.0f * scale;
        float overlayHeight = 110.0f * scale;
        Vector2f overlayPos = overlay.getPosition(0.0f, 0.0f, window.getGuiScaledWidth(), window.getGuiScaledHeight(), overlayWidth, overlayHeight);
        Vector2f center = new Vector2f(overlayPos.x + overlayWidth / 2.0f, overlayPos.y + overlayHeight / 2.0f);
        HealthContainer container = (HealthContainer)camera.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        HealthContainerDefinition definition = container.getDefinition();
        List<BodyPartDisplay> displays = definition.getDisplayConfiguration();
        for (BodyPartDisplay display : displays) {
            BodyPart health = container.getBodyPart(display.source());
            if (health == null) {
                return;
            }
            Vector4f pos = display.getPosition(scale, center);
            int color = overlay.transparency << 24 | HealthLayer.getColor(overlay.deadLimbColor, overlay.colorSchema, health);
            RenderUtils.fill((GuiGraphics)graphics, (float)pos.x, (float)pos.y, (float)(pos.x + pos.z), (float)(pos.y + pos.w), (int)ARGB.scaleRGB((int)color, (float)0.8f));
            RenderUtils.fill((GuiGraphics)graphics, (float)(pos.x + 2.0f), (float)(pos.y + 2.0f), (float)(pos.x + pos.z - 2.0f), (float)(pos.y + pos.w - 2.0f), (int)color);
        }
        Stream<StatusEffect> effectStream = container.getStatusEffectStream().filter(effect -> StatusEffectType.isVisible(effect, EffectVisibility.ALWAYS));
        Map effects = effectStream.collect(Collectors.groupingBy(StatusEffect::getType, LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        for (Map.Entry entry : effects.entrySet()) {
            StatusEffectType type = (StatusEffectType)entry.getKey();
            List effectList = (List)entry.getValue();
            ResourceLocation icon = type.getIcon((StatusEffect)effectList.getFirst());
            int x = (int)(overlayPos.x() + overlayWidth);
            int y = (int)(overlayPos.y() + (float)(index++ * 12));
            RenderUtils.blitFull((GuiGraphics)graphics, (ResourceLocation)icon, (int)x, (int)y, (int)(x + 12), (int)(y + 12), (int)-1);
            int count = effectList.size();
            if (count <= 1) continue;
            String text = String.valueOf(count);
            graphics.drawString(client.font, text, x + 12 - client.font.width(text), y + 4, -1);
        }
    }

    public static int getColor(String deadLimbColor, String[] colorSchema, BodyPart part) {
        if (part.isDead()) {
            return Integer.decode(deadLimbColor);
        }
        if (colorSchema.length == 0) {
            return 0xBBBBBB;
        }
        if (colorSchema.length == 1) {
            return Integer.decode(colorSchema[0]);
        }
        float percent = 1.0f - part.getHealthPercent();
        if (percent <= 0.0f) {
            return Integer.decode(colorSchema[0]);
        }
        if (percent >= 1.0f) {
            return Integer.decode(colorSchema[colorSchema.length - 1]);
        }
        float step = 1.0f / (float)(colorSchema.length - 1);
        int stepIndex = Mth.floor((float)(percent / step));
        int baseColor = Integer.decode(colorSchema[stepIndex]);
        int transitionColor = Integer.decode(colorSchema[stepIndex + 1]);
        float transitionPercent = (percent - (float)stepIndex * step) / step;
        return ARGB.lerp((float)transitionPercent, (int)baseColor, (int)transitionColor) & 0xFFFFFF;
    }
}

