/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.api.event.EntityWeightUpdateEvent;
import tnt.tarkovcraft.core.api.event.StaminaEvent;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.energy.EnergySystem;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.ArmorComponent;
import tnt.tarkovcraft.medsystem.api.event.WoundStatusEffectApplyEvent;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.effect.OverweightStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.WoundStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDamageTypes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public final class MedicalSystemEventHandler {
    @SubscribeEvent
    private void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (event.isCanceled()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MedicalSystem.HEALTH_SYSTEM.getHealthContainer(livingEntity).ifPresent(container -> {
                container.bind(livingEntity);
                HealthSystem.synchronizeEntity(livingEntity);
            });
            if (livingEntity.getType() == EntityType.PLAYER && !BloodSystem.hasBloodDataIntegration(livingEntity)) {
                livingEntity.setData(MedSystemDataAttachments.BLOOD_DATA, (Object)new BloodData(5.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    private void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        float amount = event.getAmount();
        if (event.isCanceled()) {
            return;
        }
        if (amount > 0.0f && HealthSystem.hasCustomHealth((Entity)entity)) {
            float leftover = ((HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER)).heal(entity, amount, null);
            if (leftover > 0.0f) {
                event.setAmount(amount - leftover);
            }
            HealthSystem.synchronizeEntity(entity);
        }
    }

    @SubscribeEvent
    private void onInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        if (event.isInvulnerable()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!HealthSystem.hasCustomHealth((Entity)livingEntity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        if (BloodSystem.isEntityUnconscious(livingEntity) && source.is(DamageTypes.IN_WALL)) {
            event.setInvulnerable(true);
            return;
        }
        HitCalculator hitCalculator = HealthSystem.getHitCalculator(livingEntity, source, container);
        List<HitResult> hits = hitCalculator.calculateHits(livingEntity, source, container);
        if (hits == null || hits.isEmpty()) {
            event.setInvulnerable(true);
        } else {
            DamageContext context = new DamageContext(livingEntity, source);
            context.setHits(hits);
            context.setHitCalculator(hitCalculator);
            context.setSideEffects(SideEffectHolder.fromDamage(source));
            container.setDamageContext(context);
        }
    }

    @SubscribeEvent
    private void onArmorHit(ArmorHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ArmorComponent component = (ArmorComponent)HealthSystem.ARMOR.getComponent();
        if (!HealthSystem.hasCustomHealth((Entity)entity) || component.useVanillaArmorDamage()) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageContext context = container.getDamageContext();
        HashSet<EquipmentSlot> hitSlots = new HashSet<EquipmentSlot>(context.getAffectedSlots());
        HashSet armorSlots = new HashSet(event.getArmorMap().keySet());
        Map map = event.getArmorMap();
        float damageReductionMultiplier = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.ARMOR_DURABILITY, (float)1.0f);
        for (EquipmentSlot slot : armorSlots) {
            if (!hitSlots.contains(slot)) {
                map.remove(slot);
                continue;
            }
            float damage = event.getNewDamage(slot).floatValue();
            if (!(damage > 0.0f) || damageReductionMultiplier == 1.0f) continue;
            event.setNewDamage(slot, Math.max(damage * damageReductionMultiplier, 1.0f));
        }
    }

    @SubscribeEvent
    private void onLivingDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageContext context = container.getDamageContext();
        List<HitResult> hits = context.getHits();
        EnumSet<BodyPartGroup> hitGroups = EnumSet.noneOf(BodyPartGroup.class);
        for (HitResult hit : hits) {
            BodyPart bodyPart = hit.bodyPart();
            BodyPartGroup group2 = bodyPart.getGroup();
            hitGroups.add(group2);
        }
        ArmorComponent component = (ArmorComponent)HealthSystem.ARMOR.getComponent();
        EnumSet<BodyPartGroup> protectedGroups = EnumSet.noneOf(BodyPartGroup.class);
        component.collectAffectedBodyPartsWithProtection(protectedGroups::add, entity, context);
        protectedGroups.removeIf(group -> !hitGroups.contains(group));
        Set<EquipmentSlot> protectedSlots = protectedGroups.stream().flatMap(group -> group.getArmorSlots().stream()).collect(Collectors.toSet());
        context.setAffectedSlots(new ArrayList<EquipmentSlot>());
        float reduction = component.handleReductions(entity, context, protectedSlots, () -> ((LivingIncomingDamageEvent)event).getAmount(), arg_0 -> ((LivingIncomingDamageEvent)event).setAmount(arg_0), (arg_0, arg_1) -> ((LivingIncomingDamageEvent)event).addReductionModifier(arg_0, arg_1));
        if (reduction > 0.0f) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.ARMOR_USE, (Entity)entity, (float)reduction);
        }
    }

    @SubscribeEvent
    private void onLivingApplyDamage(LivingDamageEvent.Post event) {
        int duration;
        WoundStatusEffectApplyEvent applyEvent;
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        DamageContext context = container.getDamageContext();
        DamageDistributor damageDistributor = context.getDamageDistributor(container);
        Map<BodyPart, Float> distributedDamage = damageDistributor.distribute(context, container, event.getNewDamage());
        ArrayList lostBodyParts = new ArrayList();
        SideEffectHolder sideEffects = context.getSideEffects();
        container.hurt(context, distributedDamage, sideEffects, lostBodyParts::add);
        float totalDamage = distributedDamage.values().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.DAMAGE_TAKEN, (Entity)entity, (float)totalDamage);
        }
        if ((applyEvent = (WoundStatusEffectApplyEvent)NeoForge.EVENT_BUS.post((Event)new WoundStatusEffectApplyEvent(entity, context, totalDamage, duration = Mth.floor((float)(totalDamage / 4.0f))))).shouldApplyEffect()) {
            StatusEffectHelper.addEffect(container.getGlobalStatusEffects(), entity, null, 1, new WoundStatusEffect(applyEvent.getDurationSeconds() * 20));
        }
        container.clearDamageContext();
        container.updateHealth(entity);
        HealthSystem.synchronizeEntity(entity);
        if (container.shouldDie()) {
            entity.setHealth(0.0f);
            return;
        }
        if (BloodSystem.hasBloodDataIntegration(entity) && !entity.level().isClientSide()) {
            float unconsciousChance;
            RandomSource random = entity.getRandom();
            BloodData bloodData = BloodSystem.getBloodData(entity);
            MedSystemConfig config = MedicalSystem.getConfig();
            int limbLostCount = lostBodyParts.size();
            if (!bloodData.isUnconscious() && config.allowUnconsciousOnLimbLost && limbLostCount > 0 && (unconsciousChance = (float)limbLostCount * AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.UNCONSCIOUS_ON_LIMB_LOSS_CHANCE, (float)0.2f)) > 0.0f && random.nextFloat() < unconsciousChance) {
                int unconsciousDuration = limbLostCount * Duration.seconds((int)10).tickValue();
                bloodData.setOrExtendedUnconsciousTime(unconsciousDuration, BloodData.UnconsciousInfo.PAIN);
            }
            bloodData.sync(entity);
        }
        MovementStaminaComponent component = (MovementStaminaComponent)EnergySystem.MOVEMENT_STAMINA.getComponent();
        if (entity.isSprinting() && !component.canSprint(entity)) {
            entity.setSprinting(false);
        }
    }

    @SubscribeEvent
    private void onWeightUpdate(EntityWeightUpdateEvent event) {
        LivingEntity entity = event.getEntity();
        float factor = event.getOverweightFactor();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = HealthSystem.getHealthData(entity);
        StatusEffectMap effects = container.getGlobalStatusEffects();
        if (factor > 0.0f) {
            effects.replace(new OverweightStatusEffect(factor >= 1.0f));
        } else {
            effects.remove(StatusEffectSubmitter.NOOP, MedSystemStatusEffects.OVERWEIGHT, container, entity, null);
        }
        HealthSystem.synchronizeEntity(entity);
    }

    @SubscribeEvent
    private void canSprint(StaminaEvent.CanSprint event) {
        LivingEntity entity = event.getEntity();
        MedSystemConfig config = MedicalSystem.getConfig();
        if (config.statusEffects.enableStatusEffects && HealthSystem.isMovementRestricted(entity) && !HealthSystem.hasPainRelief(entity)) {
            event.setCanSprint(Boolean.valueOf(false));
        }
    }

    @SubscribeEvent
    private void onSprinted(StaminaEvent.AfterSprint event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        MedSystemConfig config = MedicalSystem.getConfig();
        long gameTime = level.getGameTime();
        if (level.isClientSide()) {
            return;
        }
        if (config.statusEffects.enableStatusEffects && gameTime % 20L == 0L && HealthSystem.isMovementRestricted(entity)) {
            RegistryAccess access = entity.registryAccess();
            entity.hurtServer((ServerLevel)level, MedSystemDamageTypes.causeFractureDamage(access), 0.25f);
        }
    }

    @SubscribeEvent
    private void afterJump(StaminaEvent.AfterJump event) {
        LivingEntity entity = event.getEntity();
        MedSystemConfig config = MedicalSystem.getConfig();
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (config.statusEffects.enableStatusEffects && HealthSystem.isMovementRestricted(entity)) {
            RegistryAccess access = entity.registryAccess();
            entity.hurtServer((ServerLevel)level, MedSystemDamageTypes.causeFractureDamage(access), 0.5f);
        }
    }

    @SubscribeEvent
    private void onLivingDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (HealthSystem.hasCustomHealth((Entity)entity)) {
            HealthContainer container = HealthSystem.getHealthData(entity);
            container.invalidate();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    private void addItemstackTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item.TooltipContext context = event.getContext();
        List tooltip = event.getToolTip();
        TooltipFlag flag = event.getFlags();
        Consumer<Component> adder = tooltip::add;
        stack.addToTooltip(MedSystemItemComponents.HEAL_ATTRIBUTES, context, adder, flag);
        stack.addToTooltip(MedSystemItemComponents.SIDE_EFFECTS, context, adder, flag);
    }

    @SubscribeEvent
    private void onItemUseFinished(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (stack.has(MedSystemItemComponents.SIDE_EFFECTS)) {
            SideEffectHolder holder = (SideEffectHolder)stack.get(MedSystemItemComponents.SIDE_EFFECTS);
            InteractionTarget target = (InteractionTarget)stack.get(MedSystemItemComponents.INTERACTION_TARGET);
            String targetLimb = target != null ? target.limbCode() : null;
            LivingEntity targetEntity = entity;
            if (target != null) {
                targetEntity = target.getTargetLivingEntity(entity);
            }
            if (!HealthSystem.hasCustomHealth((Entity)targetEntity)) {
                return;
            }
            HealthContainer container = HealthSystem.getHealthData(targetEntity);
            BodyPart part = container.getBodyPart(targetLimb);
            holder.apply(targetEntity, container, part);
        }
    }

    @SubscribeEvent
    private void adjustHitboxSize(EntityEvent.Size event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER && event.getPose() == BloodData.UNCONSCIOUS_POSE && BloodSystem.isEntityUnconscious((LivingEntity)(player = (Player)entity))) {
            event.setNewSize(BloodData.PLAYER_UNCONSCIOUS_DIMENSIONS);
        }
    }

    @SubscribeEvent
    private void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        BloodData data = BloodSystem.getBloodData((LivingEntity)player);
        data.updateEffects((LivingEntity)player);
    }
}

