/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tnt.tarkovcraft.medsystem.api.heal.SideEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupHolder;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffectGroupItems;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public class BloodRecoveryEffectGroupItem
implements EffectGroupItem {
    public static final MapCodec<BloodRecoveryEffectGroupItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("amount").forGetter(t -> Float.valueOf(t.amount))).apply((Applicative)instance, BloodRecoveryEffectGroupItem::new));
    private final float amount;

    public BloodRecoveryEffectGroupItem(float amount) {
        this.amount = amount;
    }

    @Override
    public void init(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
    }

    @Override
    public void cleanup(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
    }

    @Override
    public void apply(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        Level level = entity.level();
        long time = level.getGameTime();
        if (time % 20L != 0L) {
            return;
        }
        if (BloodSystem.hasBloodDataIntegration(entity)) {
            BloodData data = BloodSystem.getBloodData(entity);
            data.setBloodVolume(data.getBloodVolume() + this.amount);
            data.sync(entity);
        }
    }

    @Override
    public void addInformation(EffectGroupHolder holder, Consumer<Component> tooltip, boolean isItemTooltip) {
        EffectType type = this.amount > 0.0f ? EffectType.POSITIVE : EffectType.NEGATIVE;
        MutableComponent label = Component.translatable((String)("label.medsystem." + (this.amount > 0.0f ? "blood_recovery" : "blood_loss")), (Object[])new Object[]{Component.literal((String)String.format(Locale.ROOT, "%.1f", Float.valueOf(this.amount * 1000.0f)))});
        if (isItemTooltip) {
            tooltip.accept(SideEffect.createDescriptionComponent(type, (Component)label, 1.0f, holder.getDuration(), holder.getDelay()));
        } else {
            tooltip.accept((Component)label.append(" ").append(StatusEffect.getDurationLabel(holder.getDuration())).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    public boolean isVisible() {
        return this.amount != 0.0f;
    }

    @Override
    public EffectGroupItem copy() {
        return new BloodRecoveryEffectGroupItem(this.amount);
    }

    @Override
    public EffectGroupHolder tryToMergeWith(EffectGroupHolder current, EffectGroupHolder other) {
        return null;
    }

    @Override
    public EffectGroupItemType<?> getType() {
        return (EffectGroupItemType)MedSystemStatusEffectGroupItems.BLOOD_RECOVERY.value();
    }
}

