/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDefinition;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;

public final class BodyPart {
    public static final Codec<BodyPart> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(t -> t.name), (App)Codec.BOOL.fieldOf("vital").forGetter(t -> t.vital), (App)Codec.FLOAT.fieldOf("health").forGetter(t -> Float.valueOf(t.health)), (App)Codec.FLOAT.fieldOf("maxHealth").forGetter(t -> Float.valueOf(t.maxHealth)), (App)Codec.FLOAT.fieldOf("originalMaxHealth").forGetter(t -> Float.valueOf(t.originalMaxHealth)), (App)Codec.FLOAT.fieldOf("parentDamageScale").forGetter(t -> Float.valueOf(t.parentDamageScale)), (App)Codec.FLOAT.fieldOf("damageScale").forGetter(t -> Float.valueOf(t.damageScale)), (App)Codecs.simpleEnumCodec(BodyPartGroup.class).fieldOf("group").forGetter(t -> t.group), (App)StatusEffectMap.CODEC.fieldOf("statusEffects").forGetter(t -> t.statusEffects)).apply((Applicative)instance, BodyPart::new));
    private BodyPartDefinition definition;
    private final String name;
    private final boolean vital;
    private final float originalMaxHealth;
    private float health;
    private float maxHealth;
    private final float parentDamageScale;
    private final float damageScale;
    private final BodyPartGroup group;
    private final Component displayName;
    private final StatusEffectMap statusEffects;

    public BodyPart(String name, boolean vital, float maxHealth, float parentDamageScale, float damageScale, BodyPartGroup group) {
        this(name, vital, maxHealth, maxHealth, maxHealth, parentDamageScale, damageScale, group, new StatusEffectMap());
    }

    private BodyPart(String name, boolean vital, float health, float maxHealth, float originalMaxHealth, float parentDamageScale, float damageScale, BodyPartGroup group, StatusEffectMap statusEffects) {
        this.name = name;
        this.vital = vital;
        this.health = health;
        this.maxHealth = maxHealth;
        this.originalMaxHealth = originalMaxHealth;
        this.parentDamageScale = parentDamageScale;
        this.damageScale = damageScale;
        this.group = group;
        this.displayName = Component.translatable((String)("medsystem.bodypart." + name));
        this.statusEffects = statusEffects;
    }

    public void setDefinition(BodyPartDefinition definition) {
        this.definition = definition;
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public float getParentDamageScale() {
        return this.parentDamageScale;
    }

    public float getDamageScale() {
        return this.damageScale;
    }

    public boolean shouldOwnerDie() {
        return this.vital && this.health <= 0.0f;
    }

    public boolean isDead() {
        return this.health <= 0.0f;
    }

    public boolean isVital() {
        return this.vital;
    }

    public BodyPartGroup getGroup() {
        return this.group;
    }

    public float getHealth() {
        return this.health;
    }

    public float getHealthPercent() {
        return this.health / this.maxHealth;
    }

    public void setHealth(float health) {
        this.health = Mth.clamp((float)health, (float)0.0f, (float)this.maxHealth);
    }

    public void heal(float amount) {
        this.setHealth(this.health + amount);
    }

    public void hurt(float amount) {
        this.setHealth(this.health - amount);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
        this.setHealth(this.health);
    }

    public float getMaxHealAmount() {
        return this.maxHealth - this.health;
    }

    public float getOriginalMaxHealth() {
        return this.originalMaxHealth;
    }

    public StatusEffectMap getStatusEffects() {
        return this.statusEffects;
    }

    public void trigger(HealthContainer container, LivingEntity entity, DamageSource source) {
        this.definition.getReactions().forEach(def -> def.react(container, entity, source, this));
    }

    public void tick(HealthContainer container, LivingEntity entity) {
        this.statusEffects.tick(container, entity, this);
        this.definition.getReactions().forEach(def -> def.react(container, entity, null, this));
    }

    public boolean equals(Object o) {
        if (!(o instanceof BodyPart)) {
            return false;
        }
        BodyPart part = (BodyPart)o;
        return Objects.equals(this.name, part.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

