/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import tnt.tarkovcraft.core.common.statistic.StatisticTracker;
import tnt.tarkovcraft.core.network.Synchronizable;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.effect.PainStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.QueuedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectHelper;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDefinition;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStats;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public final class HealthContainer
implements Synchronizable<HealthContainer> {
    public static final MapCodec<HealthContainer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)HealthContainerDefinition.CODEC.fieldOf("def").forGetter(t -> t.definition), (App)Codec.unboundedMap((Codec)Codec.STRING, BodyPart.CODEC).fieldOf("bodyParts").forGetter(t -> t.bodyParts), (App)StatusEffectMap.CODEC.fieldOf("effects").forGetter(t -> t.statusEffects), (App)Codecs.collection(QueuedStatusEffect.CODEC, list -> new PriorityQueue(list), ArrayList::new).optionalFieldOf("effectQueue", new PriorityQueue()).forGetter(t -> t.effectQueue), (App)Codec.BOOL.optionalFieldOf("invalidated", (Object)false).forGetter(t -> t.invalidated)).apply((Applicative)instance, HealthContainer::new));
    public static final Codec<HealthContainer> CODEC = MAP_CODEC.codec();
    private final HealthContainerDefinition definition;
    private final Map<String, BodyPart> bodyParts;
    private final Map<BodyPart, BodyPart> bodyPartLinks;
    private final List<BodyPart> vitalParts;
    private final String root;
    private final StatusEffectMap statusEffects;
    private final Queue<QueuedStatusEffect> effectQueue;
    private DamageContext activeDamageContext;
    private boolean invalidated;

    public HealthContainer(IAttachmentHolder holder) {
        if (!(holder instanceof LivingEntity)) {
            throw new IllegalArgumentException("Holder must be an instance of LivingEntity");
        }
        LivingEntity livingEntity = (LivingEntity)holder;
        this.definition = MedicalSystem.HEALTH_SYSTEM.getHealthContainer(livingEntity).orElse(null);
        this.statusEffects = new StatusEffectMap();
        this.effectQueue = new PriorityQueue<QueuedStatusEffect>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.definition != null) {
            for (Map.Entry<String, BodyPartDefinition> entry : this.definition.getBodyParts().entrySet()) {
                String key = entry.getKey();
                BodyPartDefinition partDefinition = entry.getValue();
                builder.put((Object)key, (Object)partDefinition.createContainer(key));
            }
            this.bodyParts = builder.build();
            this.bodyPartLinks = new IdentityHashMap<BodyPart, BodyPart>();
            this.vitalParts = new ArrayList<BodyPart>();
            this.root = this.resolveBodyParts(this.definition, this.bodyPartLinks, this.vitalParts);
        } else {
            this.bodyParts = Collections.emptyMap();
            this.bodyPartLinks = Collections.emptyMap();
            this.vitalParts = Collections.emptyList();
            this.root = "";
        }
    }

    private HealthContainer(HealthContainerDefinition definition, Map<String, BodyPart> bodyParts, StatusEffectMap statusEffects, Queue<QueuedStatusEffect> effectQueue, boolean invalidated) {
        this.definition = definition;
        this.bodyParts = bodyParts;
        this.bodyPartLinks = new IdentityHashMap<BodyPart, BodyPart>();
        this.vitalParts = new ArrayList<BodyPart>();
        this.root = this.resolveBodyParts(this.definition, this.bodyPartLinks, this.vitalParts);
        this.statusEffects = statusEffects;
        this.effectQueue = new PriorityQueue<QueuedStatusEffect>(effectQueue);
        this.invalidated = invalidated;
    }

    public void tick(LivingEntity entity) {
        if (this.invalidated) {
            this.clearBoundData(entity);
        } else {
            float previousHealth = this.getHealth();
            this.tickEffectQueue(entity);
            this.tickStatusEffectCheck(entity, 20, false);
            this.statusEffects.tick(this, entity, null);
            for (BodyPart part : this.bodyParts.values()) {
                part.tick(this, entity);
            }
            float health = this.getHealth();
            if (health != previousHealth) {
                this.updateHealth(entity);
            }
        }
    }

    public void clearBoundData(LivingEntity entity) {
        if (!this.statusEffects.isEmpty()) {
            this.statusEffects.removeAll(StatusEffectSubmitter.NOOP, this, entity, null);
        }
        for (BodyPart part : this.bodyParts.values()) {
            StatusEffectMap map = part.getStatusEffects();
            if (map.isEmpty()) continue;
            map.removeAll(StatusEffectSubmitter.NOOP, this, entity, part);
        }
        this.effectQueue.clear();
    }

    public void scheduleStatusEffect(LivingEntity entity, int delay, @Nullable BodyPart part, StatusEffect effect) {
        String partId = part != null ? part.getName() : "";
        Level level = entity.level();
        long target = level.getGameTime() + (long)delay;
        QueuedStatusEffect queuedStatusEffect = new QueuedStatusEffect(target, partId, effect);
        this.effectQueue.offer(queuedStatusEffect);
    }

    public StatusEffectMap getGlobalStatusEffects() {
        return this.statusEffects;
    }

    public void invalidate() {
        this.invalidated = true;
    }

    public boolean isInvalid() {
        return this.definition == null || this.bodyParts.isEmpty() || this.invalidated;
    }

    public HealthContainerDefinition getDefinition() {
        return this.definition;
    }

    public boolean hasBodyPart(String part) {
        return this.bodyParts.containsKey(part);
    }

    public BodyPart getBodyPart(@Nullable String name) {
        return this.bodyParts.get(name != null ? name : this.root);
    }

    public BodyPart getRootBodyPart() {
        return this.getBodyPart(null);
    }

    public Stream<BodyPart> getBodyPartStream() {
        return this.bodyParts.values().stream();
    }

    public Stream<StatusEffect> getStatusEffectStream() {
        return Stream.concat(this.statusEffects.getEffectsStream(), this.bodyParts.values().stream().flatMap(part -> part.getStatusEffects().getEffectsStream()));
    }

    public boolean hasMatchingStatusEffect(TagKey<StatusEffectType<?>> tag) {
        return this.getStatusEffectStream().anyMatch(effect -> effect.getType().is(tag));
    }

    public boolean removeMatchingStatusEffects(TagKey<StatusEffectType<?>> tag, LivingEntity entity) {
        boolean modified = this.statusEffects.removeMatching(StatusEffectSubmitter.NOOP, tag, this, entity, null);
        for (BodyPart part : this.bodyParts.values()) {
            modified |= part.getStatusEffects().removeMatching(StatusEffectSubmitter.NOOP, tag, this, entity, part);
        }
        return modified;
    }

    public float getHealth() {
        float health = 0.0f;
        for (BodyPart bodyPart : this.bodyParts.values()) {
            if (bodyPart.shouldOwnerDie()) {
                return 0.0f;
            }
            health += bodyPart.getHealth();
        }
        return health;
    }

    public float getMaxHealth() {
        float maxHealth = 0.0f;
        for (BodyPart bodyPart : this.bodyParts.values()) {
            maxHealth += bodyPart.getMaxHealth();
        }
        return maxHealth;
    }

    public float getOriginalMaxHealth() {
        float maxHealth = 0.0f;
        for (BodyPart bodyPart : this.bodyParts.values()) {
            maxHealth += bodyPart.getOriginalMaxHealth();
        }
        return maxHealth;
    }

    public void updateHealth(LivingEntity entity) {
        float playerMaxHealth = entity.getMaxHealth();
        float containerMaxHealth = this.getMaxHealth();
        float originalContainerMaxHealth = this.getOriginalMaxHealth();
        if (playerMaxHealth != containerMaxHealth) {
            if (playerMaxHealth == originalContainerMaxHealth) {
                for (BodyPart bodyPart : this.bodyParts.values()) {
                    bodyPart.setMaxHealth(bodyPart.getOriginalMaxHealth());
                }
            } else {
                double diff = playerMaxHealth - containerMaxHealth;
                int parts = this.bodyParts.size();
                double perPart = diff / (double)parts;
                for (BodyPart bodyPart : this.bodyParts.values()) {
                    float newMaxHealth = (float)((double)bodyPart.getMaxHealth() + perPart);
                    bodyPart.setMaxHealth(Math.max(newMaxHealth, 1.0f));
                }
            }
        }
        float health = this.getHealth();
        entity.setHealth(health);
    }

    public void hurt(DamageContext context, Map<BodyPart, Float> distributedDamage, @Nullable SideEffectHolder effects, Consumer<BodyPart> onLimbDeath) {
        for (Map.Entry<BodyPart, Float> entry : distributedDamage.entrySet()) {
            BodyPart bodyPart = entry.getKey();
            float amount = entry.getValue().floatValue();
            this.hurt(context, amount, bodyPart, onLimbDeath);
            if (effects == null) continue;
            effects.applyFromDamage(context.getEntity(), context.getSource(), this, bodyPart);
        }
    }

    public void hurt(DamageContext context, float amount, BodyPart part, Consumer<BodyPart> onBodyPartLoss) {
        BodyPart parent;
        float damage = Math.min(part.getHealth(), amount * part.getDamageScale());
        float leftover = amount - damage;
        boolean wasDead = part.isDead();
        LivingEntity entity = context.getEntity();
        DamageSource source = context.getSource();
        part.hurt(damage);
        part.trigger(this, entity, source);
        if (!part.isVital() && part.isDead() != wasDead) {
            StatisticTracker.incrementOptional((IAttachmentHolder)entity, MedSystemStats.LIMBS_LOST);
            onBodyPartLoss.accept(part);
        }
        if (!part.isVital() && leftover > 0.0f && (parent = this.bodyPartLinks.get(part)) != null) {
            float scale = parent.getParentDamageScale();
            this.hurt(context, leftover * scale, parent, onBodyPartLoss);
        }
    }

    public boolean canHeal(@Nullable BodyPart part, boolean allowDead) {
        if (part != null) {
            return part.isDead() && allowDead || part.getMaxHealAmount() > 0.0f;
        }
        return this.getPartToHeal(allowDead) != null;
    }

    public float heal(LivingEntity entity, float amount, @Nullable BodyPart targetPart) {
        BodyPart part;
        if (targetPart != null && !targetPart.isDead()) {
            float healAmount = Math.min(amount, targetPart.getMaxHealAmount());
            targetPart.heal(healAmount);
            targetPart.trigger(this, entity, null);
            return amount - healAmount;
        }
        while (amount > 0.0f && (part = this.getPartToHeal(false)) != null) {
            float healAmount = Math.min(amount, part.getMaxHealAmount());
            part.heal(healAmount);
            part.trigger(this, entity, null);
            amount -= healAmount;
        }
        return amount;
    }

    public void setDamageContext(DamageContext damageContext) {
        if (this.activeDamageContext == null || this.activeDamageContext.getId() != damageContext.getId()) {
            this.activeDamageContext = damageContext;
        }
    }

    public void clearDamageContext() {
        this.activeDamageContext = null;
    }

    public DamageContext getDamageContext() {
        return this.activeDamageContext;
    }

    public Codec<HealthContainer> networkCodec() {
        return CODEC;
    }

    public boolean shouldDie() {
        float health = 0.0f;
        for (BodyPart part : this.bodyParts.values()) {
            health += part.getHealth();
            if (!part.shouldOwnerDie()) continue;
            return true;
        }
        return health <= 0.0f;
    }

    public void acceptHitboxes(BiConsumer<BodyPartHitbox, BodyPart> consumer) {
        this.acceptHitboxes((hb, p) -> true, consumer);
    }

    public void acceptHitboxes(BiPredicate<BodyPartHitbox, BodyPart> filter, BiConsumer<BodyPartHitbox, BodyPart> consumer) {
        for (BodyPartHitbox hitbox : this.definition.getHitboxes()) {
            BodyPart part = this.bodyParts.get(hitbox.getOwner());
            if (part == null || !filter.test(hitbox, part)) continue;
            consumer.accept(hitbox, part);
        }
    }

    public BodyPart getPartToHeal(boolean allowDead) {
        BodyPart targetPart = null;
        float targetPercentage = 1.0f;
        MedSystemConfig config = MedicalSystem.getConfig();
        if (config.prioritizeVitalHealing) {
            for (BodyPart vitalPart : this.vitalParts) {
                float percentage;
                if (vitalPart.isDead() && !allowDead || !((percentage = vitalPart.getHealthPercent()) < config.vitalBodyPartHealthTrigger) || !(percentage < targetPercentage)) continue;
                targetPercentage = percentage;
                targetPart = vitalPart;
            }
        }
        if (targetPart != null) {
            return targetPart;
        }
        BodyPart target = null;
        for (BodyPart part : this.bodyParts.values()) {
            float percentage;
            if (part.isDead() && !allowDead || !((percentage = part.getHealthPercent()) < 1.0f) || !(percentage < targetPercentage)) continue;
            target = part;
            targetPercentage = percentage;
        }
        return target;
    }

    public void markStatusEffectAdded(LivingEntity entity) {
        this.tickStatusEffectCheck(entity, 0, true);
    }

    private String resolveBodyParts(HealthContainerDefinition definition, Map<BodyPart, BodyPart> links, List<BodyPart> vitalParts) {
        String root = null;
        for (Map.Entry<String, BodyPartDefinition> health : definition.getBodyParts().entrySet()) {
            String part = health.getKey();
            String parent = health.getValue().getParent();
            BodyPart bodyPart = this.bodyParts.get(part);
            if (parent == null) {
                root = part;
            } else {
                links.put(bodyPart, this.bodyParts.get(parent));
            }
            BodyPartDefinition healthDef = health.getValue();
            if (healthDef.isVital()) {
                vitalParts.add(bodyPart);
            }
            bodyPart.setDefinition(healthDef);
        }
        return root;
    }

    private void tickEffectQueue(LivingEntity entity) {
        QueuedStatusEffect effect;
        long gameTime = entity.level().getGameTime();
        boolean modified = false;
        while ((effect = this.effectQueue.peek()) != null && effect.isReady(gameTime)) {
            this.effectQueue.poll();
            String limbCode = effect.limb();
            StatusEffectMap map = this.statusEffects;
            BodyPart part = null;
            if (!limbCode.isBlank()) {
                part = this.bodyParts.get(limbCode);
                if (part == null) continue;
                map = part.getStatusEffects();
            }
            StatusEffectHelper.addEffect(map, entity, part, effect.data().copy());
            modified = true;
        }
        if (modified) {
            HealthSystem.synchronizeEntity(entity);
        }
    }

    private void tickStatusEffectCheck(LivingEntity entity, int painDelay, boolean forcedTick) {
        long time = entity.level().getGameTime();
        if ((forcedTick || time % 20L == 0L) && !this.statusEffects.hasEffect(MedSystemStatusEffects.PAIN) && HealthSystem.isInPain(entity)) {
            StatusEffectHelper.addEffect(this.statusEffects, entity, null, painDelay, new PainStatusEffect(-1));
        }
    }
}

