/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.FullDamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;
import tnt.tarkovcraft.medsystem.common.health.math.ScaledDamageDistributor;

public class ExplosionHitCalculator
implements HitCalculator {
    public static final ExplosionHitCalculator INSTANCE = new ExplosionHitCalculator();

    public static boolean isValidExplosionSource(DamageSource source) {
        return source.is(DamageTypeTags.IS_EXPLOSION) && source.getSourcePosition() != null;
    }

    @Override
    public List<HitResult> calculateHits(LivingEntity entity, DamageSource source, HealthContainer container) {
        Vec3 explosionPosition = source.getSourcePosition();
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        container.acceptHitboxes((hitbox, part) -> this.isVisible(hitbox.getLevelPositionedAABB(entity), explosionPosition, entity.level(), entity), (hitbox, part) -> hits.add(new HitResult((BodyPartHitbox)hitbox, (BodyPart)part)));
        return hits;
    }

    @Override
    public DamageDistributor getCustomDamageDistributor(LivingEntity entity, DamageSource source, HealthContainer container, DamageDistributor original) {
        float scale = MedicalSystem.getConfig().explosionDamageScale;
        return new ScaledDamageDistributor(scale, FullDamageDistributor.INSTANCE);
    }

    protected boolean isVisible(AABB hitbox, Vec3 position, Level level, LivingEntity entity) {
        Vec3 hitboxPosition = hitbox.getCenter();
        ClipContext context = new ClipContext(position, hitboxPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        BlockHitResult result = level.clip(context);
        return result.getType() == HitResult.Type.MISS;
    }
}

