/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.mixin;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onAttributeUpdated"}, at={@At(value="RETURN")})
    private void medsystem$onAttributeUpdated(Holder<Attribute> holder, CallbackInfo ci) {
        if (this.hasData(MedSystemDataAttachments.HEALTH_CONTAINER) && holder.is(Attributes.MAX_HEALTH)) {
            LivingEntity livingEntity = (LivingEntity)this;
            ((HealthContainer)this.getData(MedSystemDataAttachments.HEALTH_CONTAINER)).updateHealth(livingEntity);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void medsystem$tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (HealthSystem.hasCustomHealth((Entity)livingEntity)) {
            HealthContainer container = HealthSystem.getHealthData(livingEntity);
            container.tick(livingEntity);
        }
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void medsystem$swing(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        livingEntity.isCrouching();
        if (livingEntity.getType() == EntityType.PLAYER && BloodSystem.isEntityUnconscious(livingEntity)) {
            ci.cancel();
        }
    }
}

