/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextImpl;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.common.MedicalSystemContextKeys;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;

public record EffectRecovery(int consumption, Holder<StatusEffectType<?>> effect, boolean extendedTooltip) implements TooltipProvider
{
    public static final Codec<EffectRecovery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("consumption", (Object)1).forGetter(EffectRecovery::consumption), (App)MedSystemRegistries.STATUS_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(EffectRecovery::effect), (App)Codec.BOOL.optionalFieldOf("extendedTooltip", (Object)true).forGetter(EffectRecovery::extendedTooltip)).apply((Applicative)instance, EffectRecovery::new));

    public boolean canRecover(HealthContainer container, @Nullable BodyPart part) {
        StatusEffectType type = (StatusEffectType)this.effect.value();
        if (type.isGlobalEffect() && part == null) {
            return false;
        }
        StatusEffectMap effects = type.isGlobalEffect() ? container.getGlobalStatusEffects() : part.getStatusEffects();
        return effects.hasEffect(this.effect);
    }

    public boolean canUse(HealthContainer container) {
        StatusEffectType type = (StatusEffectType)this.effect.value();
        if (type.isGlobalEffect()) {
            return container.getGlobalStatusEffects().hasEffect(this.effect);
        }
        return container.getBodyPartStream().anyMatch(part -> part.getStatusEffects().hasEffect(this.effect));
    }

    public void recover(LivingEntity entity, HealthContainer container, ItemStack stack, @Nullable BodyPart part) {
        StatusEffectType type = (StatusEffectType)this.effect.value();
        StatusEffectMap effects = type.isGlobalEffect() ? container.getGlobalStatusEffects() : part.getStatusEffects();
        ContextImpl context = ContextImpl.of((ContextKey)ContextKeys.LIVING_ENTITY, (Object)entity, MedicalSystemContextKeys.HEALTH_CONTAINER, (Object)container, (ContextKey)LootContextParams.TOOL, (Object)stack);
        StatusEffect statusEffect = effects.remove((StatusEffectType)this.effect.value(), (Context)context);
        if (statusEffect != null) {
            effects.addEffect(statusEffect);
        }
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        StatusEffectType type = (StatusEffectType)this.effect.value();
        MutableComponent recoveryLabel = Component.literal((String)"> ");
        if (this.extendedTooltip) {
            recoveryLabel.append((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.recoveries.use_label", (Object[])new Object[]{String.valueOf(this.consumption)})).append(" - ");
        }
        recoveryLabel.append(type.getDisplayName()).withStyle(ChatFormatting.DARK_GRAY);
        tooltipAdder.accept((Component)recoveryLabel);
    }
}

