/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import tnt.tarkovcraft.core.common.data.duration.TickValue;
import tnt.tarkovcraft.medsystem.api.heal.DeadLimbHealing;
import tnt.tarkovcraft.medsystem.api.heal.EffectRecovery;
import tnt.tarkovcraft.medsystem.api.heal.HealthRecovery;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.item.HealingItem;

public record HealItemAttributes(boolean applyGlobally, boolean alwaysConsumable, int minUseTime, DeadLimbHealing deadLimbHealing, HealthRecovery health, List<EffectRecovery> recoveries) implements TooltipProvider
{
    public static final Codec<HealItemAttributes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("applyGlobally", (Object)true).forGetter(HealItemAttributes::applyGlobally), (App)Codec.BOOL.optionalFieldOf("alwaysConsumable", (Object)false).forGetter(HealItemAttributes::alwaysConsumable), (App)Codec.INT.optionalFieldOf("minUseTime", (Object)20).forGetter(HealItemAttributes::minUseTime), (App)DeadLimbHealing.CODEC.optionalFieldOf("deadLimbHeal").forGetter(t -> Optional.ofNullable(t.deadLimbHealing)), (App)HealthRecovery.CODEC.optionalFieldOf("health").forGetter(t -> Optional.ofNullable(t.health)), (App)EffectRecovery.CODEC.listOf().optionalFieldOf("recovers", Collections.emptyList()).forGetter(HealItemAttributes::recoveries)).apply((Applicative)instance, HealItemAttributes::new));

    private HealItemAttributes(Builder builder) {
        this(!builder.requiresSpecificBodyPart, builder.alwaysConsumable, builder.minUseTime, builder.deadLimbHealing, builder.healthRecovery, builder.recoveries);
    }

    private HealItemAttributes(boolean applyGlobally, boolean alwaysConsumable, int minUseTime, Optional<DeadLimbHealing> deadLimbHealing, Optional<HealthRecovery> healthRecovery, List<EffectRecovery> recoveries) {
        this(applyGlobally, alwaysConsumable, minUseTime, (DeadLimbHealing)deadLimbHealing.orElse(null), (HealthRecovery)healthRecovery.orElse(null), recoveries);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getUseDuration(int max) {
        int duration = 0;
        if (this.deadLimbHealing != null) {
            duration += this.deadLimbHealing.useTime();
        }
        if (this.health != null) {
            duration = this.health.getMaxUseDuration(max);
        }
        return Math.max(duration, this.minUseTime());
    }

    public boolean canUseOn(LivingEntity entity, ItemStack stack, HealthContainer container) {
        if (this.alwaysConsumable) {
            return true;
        }
        if (!this.recoveries.isEmpty() && this.recoveries.stream().anyMatch(recovery -> HealingItem.checkDurability(stack, recovery.consumption()) && recovery.canUse(container))) {
            return true;
        }
        if (this.canHealDeadLimbs() && this.deadLimbHealing.canHeal(entity, container)) {
            return true;
        }
        return this.health != null && entity.getHealth() < entity.getMaxHealth();
    }

    public boolean canUseOnPart(BodyPart part, ItemStack stack, HealthContainer container) {
        if (this.alwaysConsumable) {
            return true;
        }
        if (!this.recoveries.isEmpty()) {
            for (EffectRecovery recovery : this.recoveries) {
                StatusEffectMap map;
                StatusEffectType type = (StatusEffectType)recovery.effect().value();
                StatusEffectMap statusEffectMap = map = type.isGlobalEffect() ? container.getGlobalStatusEffects() : part.getStatusEffects();
                if (!HealingItem.checkDurability(stack, recovery.consumption()) || !map.hasEffect(recovery.effect())) continue;
                return true;
            }
        }
        if (this.canHealDeadLimbs() && part.isDead()) {
            return true;
        }
        return this.health != null && part.getHealth() < part.getMaxHealth() && !part.isDead();
    }

    public boolean canHealDeadLimbs() {
        return this.deadLimbHealing != null;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (this.health != null) {
            this.health.addToTooltip(context, tooltipAdder, flag, componentGetter);
        }
        if (this.canHealDeadLimbs()) {
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.dead_limb.title").withStyle(ChatFormatting.GRAY));
            this.deadLimbHealing.addToTooltip(context, tooltipAdder, flag, componentGetter);
        }
        if (!this.recoveries.isEmpty()) {
            tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.recoveries.title").withStyle(ChatFormatting.GRAY));
            this.recoveries.forEach(recovery -> recovery.addToTooltip(context, tooltipAdder, flag, componentGetter));
        }
    }

    public static final class Builder {
        private boolean requiresSpecificBodyPart = true;
        private boolean alwaysConsumable = false;
        private int minUseTime = 20;
        DeadLimbHealing deadLimbHealing;
        private HealthRecovery healthRecovery;
        private final List<EffectRecovery> recoveries = new ArrayList<EffectRecovery>();

        private Builder() {
        }

        public Builder setNoBodyPartSelection() {
            this.requiresSpecificBodyPart = false;
            return this;
        }

        public Builder setAlwaysConsumable() {
            this.alwaysConsumable = true;
            return this;
        }

        public Builder setMinUseTime(int minUseTime) {
            this.minUseTime = minUseTime;
            return this;
        }

        public Builder setMinUseTime(TickValue minUseTime) {
            return this.setMinUseTime(minUseTime.tickValue());
        }

        public DeadLimbHealing.SurgeryBuilder surgeryItem() {
            return new DeadLimbHealing.SurgeryBuilder(this);
        }

        public Builder healing(int duration, int count, float health) {
            if (duration < 20) {
                throw new IllegalArgumentException("duration must be greater than or equal to 20");
            }
            this.healthRecovery = new HealthRecovery(duration, health, count);
            return this;
        }

        public Builder healing(TickValue duration, int count, float health) {
            return this.healing(duration.tickValue(), count, health);
        }

        public Builder unrestrictedHealing(int duration, float health) {
            return this.healing(duration, 0, health);
        }

        public Builder unrestrictedHealing(TickValue duration, float health) {
            return this.unrestrictedHealing(duration.tickValue(), health);
        }

        public Builder removesEffect(int cost, Holder<StatusEffectType<?>> effect, boolean extendedTooltip) {
            this.recoveries.add(new EffectRecovery(cost, effect, extendedTooltip));
            return this;
        }

        public Builder removesEffect(int cost, Holder<StatusEffectType<?>> effect) {
            return this.removesEffect(cost, effect, true);
        }

        public Builder removesEffect(Holder<StatusEffectType<?>> effect) {
            return this.removesEffect(1, effect, false);
        }

        public HealItemAttributes build() {
            return new HealItemAttributes(this);
        }
    }
}

