/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.client.overlay.StaminaLayer;
import tnt.tarkovcraft.core.client.screen.navigation.CoreNavigators;
import tnt.tarkovcraft.core.client.screen.navigation.NavigationEntry;
import tnt.tarkovcraft.core.client.screen.navigation.OptionalNavigationEntry;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.core.util.helper.TextHelper;
import tnt.tarkovcraft.medsystem.client.config.MedSystemClientConfig;
import tnt.tarkovcraft.medsystem.client.overlay.HealthLayer;
import tnt.tarkovcraft.medsystem.client.screen.HealthScreen;

@Mod(value="medsystem", dist={Dist.CLIENT})
public final class MedicalSystemClient {
    private static MedSystemClientConfig config;
    public static final NavigationEntry HEALTH;

    public MedicalSystemClient(IEventBus modEventBus, ModContainer container) {
        config = (MedSystemClientConfig)Configuration.registerConfig(MedSystemClientConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        modEventBus.addListener(this::registerGuiLayer);
        NeoForge.EVENT_BUS.addListener(this::prepareLayerRender);
        CoreNavigators.CHARACTER_NAVIGATION_PROVIDER.register(HEALTH);
    }

    public static MedSystemClientConfig getConfig() {
        return config;
    }

    private void registerGuiLayer(RegisterGuiLayersEvent event) {
        event.registerAbove(StaminaLayer.LAYER_ID, HealthLayer.LAYER_ID, (GuiLayer)new HealthLayer());
    }

    private void prepareLayerRender(RenderGuiLayerEvent.Pre event) {
        if (!MedicalSystemClient.config.renderHealth && event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            event.setCanceled(true);
        }
    }

    static {
        HEALTH = new OptionalNavigationEntry((Component)TextHelper.createScreenTitle((String)"medsystem", (String)"health"), ctx -> {
            UUID clientId = Minecraft.getInstance().player.getUUID();
            return ctx.get(ContextKeys.UUID).filter(uuid -> uuid.equals(clientId)).isPresent();
        }, HealthScreen::new, 25);
    }
}

