/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.client.screen.SharedScreenState;
import tnt.tarkovcraft.core.client.screen.listener.SimpleClickListener;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatSettings;
import tnt.tarkovcraft.core.common.data.duration.DurationFormats;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatter;
import tnt.tarkovcraft.core.common.data.duration.DurationUnit;
import tnt.tarkovcraft.core.util.helper.MathHelper;
import tnt.tarkovcraft.core.util.helper.RenderUtils;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.config.HealthOverlayConfiguration;
import tnt.tarkovcraft.medsystem.client.overlay.HealthLayer;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;

public class BodyPartHealthWidget
extends AbstractWidget {
    private final Font font;
    private final BodyPart part;
    private int frameSize = 1;
    private int frameColor = -1;
    private int frameHoverColor = -256;
    private int backgroundColor = -16777216;
    private int textColor = -1;
    private int textHoverColor = -256;
    private float healthScale = 1.0f;
    private SimpleClickListener onClick;
    private List<StatusEffect> effects;
    private SharedScreenState<BodyPart> hoverState;

    public BodyPartHealthWidget(int x, int y, int width, int height, Font font, BodyPart part) {
        super(x, y, width, height, (Component)part.getDisplayName().copy().withStyle(ChatFormatting.BOLD));
        this.font = font;
        this.part = part;
    }

    public void setHoverState(SharedScreenState<BodyPart> hoverState) {
        this.hoverState = hoverState;
    }

    public void setEffects(List<StatusEffect> effects) {
        this.effects = effects;
    }

    public void setHealthScale(float healthScale) {
        this.healthScale = healthScale;
    }

    public void setClickListener(SimpleClickListener onClick) {
        this.onClick = onClick;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void setFrameColor(int frameColor) {
        this.frameColor = frameColor;
    }

    public void setFrameHoverColor(int frameHoverColor) {
        this.frameHoverColor = frameHoverColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    protected boolean isValidClickButton(int button) {
        return this.onClick != null;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.onClick.onClick();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean partHovered = false;
        if (this.hoverState != null) {
            if (this.isHovered) {
                this.hoverState.setState((Object)this, (Object)this.part);
            } else {
                this.hoverState.clearState((Object)this);
            }
            boolean bl = partHovered = this.hoverState.getState() != null && ((BodyPart)this.hoverState.getState()).getName().equals(this.part.getName());
        }
        if (this.frameSize > 0 && RenderUtils.isVisibleColor((int)this.frameColor)) {
            int frameColor = partHovered || this.isHovered ? this.frameHoverColor : this.frameColor;
            graphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), frameColor);
        }
        if (RenderUtils.isVisibleColor((int)this.backgroundColor)) {
            graphics.fill(this.getX() + this.frameSize, this.getY() + this.frameSize, this.getRight() - this.frameSize, this.getBottom() - this.frameSize, this.backgroundColor);
        }
        int textColor = this.part.isDead() ? -65536 : (partHovered ? this.textHoverColor : this.textColor);
        int titleWidth = this.font.width((FormattedText)this.getMessage());
        graphics.drawString(this.font, this.getMessage(), this.getX() + (this.width - titleWidth) / 2, this.getY() + 5 + this.frameSize, textColor);
        String status = Mth.ceil((float)(this.part.getHealth() * this.healthScale)) + "/" + Mth.ceil((float)(this.part.getMaxHealth() * this.healthScale));
        int statusWidth = this.font.width(status);
        graphics.drawString(this.font, status, this.getX() + (this.width - statusWidth) / 2, this.getBottom() - 14 - this.frameSize, textColor);
        HealthOverlayConfiguration overlay = MedicalSystemClient.getConfig().healthOverlay;
        int background = Integer.decode(overlay.deadLimbColor) | 0xFF000000;
        int secondaryBackground = ARGB.scaleRGB((int)background, (float)0.8f);
        int color = HealthLayer.getColor(overlay.deadLimbColor, overlay.colorSchema, this.part) | 0xFF000000;
        int secondaryColor = ARGB.scaleRGB((int)color, (float)0.8f);
        float f = this.part.getHealthPercent();
        graphics.fillGradient(this.getX() + this.frameSize + 1, this.getBottom() - this.frameSize - 5, this.getRight() - this.frameSize - 1, this.getBottom() - this.frameSize - 1, background, secondaryBackground);
        int left = this.getX() + this.frameSize + 2;
        int right = this.getRight() - this.frameSize - 2;
        graphics.fillGradient(left, this.getBottom() - this.frameSize - 4, left + (int)((float)(right - left) * f), this.getBottom() - this.frameSize - 2, color, secondaryColor);
        if (this.effects != null && !this.effects.isEmpty()) {
            for (int i = 0; i < this.effects.size(); ++i) {
                int row = i % 3;
                int col = i / 3;
                StatusEffect effect = this.effects.get(i);
                StatusEffectType<?> type = effect.getType();
                int ex = this.getRight() + col * 12;
                int ey = this.getY() + row * 12;
                RenderUtils.blitFull((GuiGraphics)graphics, (ResourceLocation)type.getIcon(), (int)ex, (int)ey, (int)(ex + 12), (int)(ey + 12), (int)-1);
                if (!MathHelper.isWithinBounds((double)mouseX, (double)mouseY, (double)ex, (double)ey, (double)12.0, (double)12.0)) continue;
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(type.getDisplayName().copy().withStyle((UnaryOperator)type.getEffectType()));
                effect.addAdditionalInfo(tooltip::add);
                if (!effect.isInfinite()) {
                    DurationFormatSettings settings = new DurationFormatSettings();
                    settings.setIncludeZeroValues(true);
                    settings.setUnits(Arrays.asList(DurationUnit.HOURS, DurationUnit.MINUTES, DurationUnit.SECONDS));
                    tooltip.add(Duration.format((int)effect.getDuration(), (DurationFormatSettings)settings, (DurationFormatter)DurationFormats.TIME).copy().withStyle(ChatFormatting.DARK_GRAY));
                }
                graphics.setTooltipForNextFrame(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

