/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextImpl;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.common.MedicalSystemContextKeys;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;

public final class TarkovCraftCommand {
    public static void create(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tarkovcraft").then(((LiteralArgumentBuilder)Commands.literal((String)"effect").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).then(Commands.literal((String)"add").then(Commands.argument((String)"bodypart", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, Duration.seconds((int)60).tickValue(), 0))).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addLocalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay"))))))))).then(Commands.literal((String)"addGlobal").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, Duration.seconds((int)60).tickValue(), 0))).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, -1, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), 0))).then(Commands.argument((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> TarkovCraftCommand.addGlobalStatusEffect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"delay")))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).then(Commands.argument((String)"bodypart", (ArgumentType)StringArgumentType.word()).executes(TarkovCraftCommand::removeLocalStatusEffect))))).then(Commands.literal((String)"removeGlobal").then(Commands.argument((String)"type", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, MedSystemRegistries.Keys.STATUS_EFFECT)).executes(TarkovCraftCommand::removeGlobalStatusEffect))))));
    }

    private static int addGlobalStatusEffect(CommandContext<CommandSourceStack> ctx, int duration, int delay) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity))) continue;
            HealthContainer container = HealthSystem.getHealthData(livingEntity);
            StatusEffectMap map = container.getGlobalStatusEffects();
            TarkovCraftCommand.addEffect(map, reference, duration, delay);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static int addLocalStatusEffect(CommandContext<CommandSourceStack> ctx, int duration, int delay) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        String bodyPartId = StringArgumentType.getString(ctx, (String)"bodypart");
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            HealthContainer container;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity)) || !(container = HealthSystem.getHealthData(livingEntity)).hasBodyPart(bodyPartId)) continue;
            BodyPart bodyPart = container.getBodyPart(bodyPartId);
            StatusEffectMap map = bodyPart.getStatusEffects();
            TarkovCraftCommand.addEffect(map, reference, duration, delay);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static <T extends StatusEffect> void addEffect(StatusEffectMap map, Holder<StatusEffectType<?>> holder, int duration, int delay) {
        StatusEffectType type = (StatusEffectType)holder.value();
        Object effect = delay > 0 ? type.createDelayedEffect(duration, delay) : type.createImmediateEffect(duration);
        map.replace(effect);
    }

    private static int removeGlobalStatusEffect(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity))) continue;
            HealthContainer container = HealthSystem.getHealthData(livingEntity);
            StatusEffectMap map = container.getGlobalStatusEffects();
            ContextImpl context = ContextImpl.of((ContextKey)ContextKeys.LIVING_ENTITY, (Object)livingEntity, MedicalSystemContextKeys.HEALTH_CONTAINER, (Object)container);
            map.remove((StatusEffectType)reference.value(), (Context)context);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }

    private static int removeLocalStatusEffect(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"type", MedSystemRegistries.Keys.STATUS_EFFECT);
        String bodyPartId = StringArgumentType.getString(ctx, (String)"bodypart");
        Collection entities = EntityArgument.getEntities(ctx, (String)"target");
        for (Entity entity : entities) {
            HealthContainer container;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !HealthSystem.hasCustomHealth((Entity)(livingEntity = (LivingEntity)entity)) || !(container = HealthSystem.getHealthData(livingEntity)).hasBodyPart(bodyPartId)) continue;
            BodyPart bodyPart = container.getBodyPart(bodyPartId);
            ContextImpl context = ContextImpl.of((ContextKey)ContextKeys.LIVING_ENTITY, (Object)livingEntity, MedicalSystemContextKeys.HEALTH_CONTAINER, (Object)container, MedicalSystemContextKeys.BODY_PART, (Object)bodyPart);
            StatusEffectMap map = bodyPart.getStatusEffects();
            map.remove((StatusEffectType)reference.value(), (Context)context);
            HealthSystem.synchronizeEntity(livingEntity);
        }
        return 0;
    }
}

