/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.config;

import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.UpdateRestrictions;

@Config(id="medsystem", filename="medicalsystem")
public final class MedSystemConfig {
    @Configurable
    @Configurable.Comment(value={"Includes all equipped armors for damage reduction calculation"})
    public boolean simpleArmorCalculation = false;
    @Configurable
    @Configurable.DecimalRange(min=0.15, max=3.0)
    @Configurable.Gui.Slider
    @Configurable.Gui.NumberFormat(value="0.00#")
    @Configurable.Comment(value={"Damage scale for explosions"})
    public float explosionDamageScale = 0.6f;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Gui.Slider
    @Configurable.Gui.NumberFormat(value="0.00#")
    @Configurable.Comment(value={"Losing limb has small chance to cause immediate death"})
    public float limbLossDeathCauseChance = 0.05f;
    @Configurable
    @Configurable.Comment(value={"Health will be primarily recovered into vital parts"})
    public boolean prioritizeVitalHealing = true;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Gui.Slider
    @Configurable.Gui.NumberFormat(value="0.0##")
    @Configurable.Comment(value={"Threshold for prioritized vital body part health recovery"})
    public float vitalBodyPartHealthTrigger = 0.75f;
    @Configurable
    @Configurable.Comment(value={"Enables hit effects such as bleeds, fractures and other effects"})
    @Configurable.Synchronized
    public boolean enableHitEffects = true;
    @Configurable
    @Configurable.Comment(value={"Allows scaling of injury recovery status effects when getting the effect repeatedly"})
    public boolean allowInjuryRecoveryScaling = true;
    @Configurable
    @Configurable.Comment(value={"Vanilla tools will have chance to cause some negative effects such as bleeds or fractures"})
    @Configurable.UpdateRestriction(value=UpdateRestrictions.GAME_RESTART)
    public boolean addHitEffectsToVanillaItems = true;
}

