/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.NotNull;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;

public final class StatusEffectMap
implements Iterable<StatusEffect> {
    public static final Codec<StatusEffectMap> CODEC = Codec.unboundedMap((Codec)MedSystemRegistries.STATUS_EFFECT.byNameCodec(), StatusEffectType.CODEC).xmap(StatusEffectMap::new, t -> t.effects);
    private final Map<StatusEffectType<?>, StatusEffect> effects;

    public StatusEffectMap() {
        this.effects = new HashMap();
    }

    private StatusEffectMap(Map<StatusEffectType<?>, StatusEffect> effects) {
        this.effects = new HashMap(effects);
    }

    public void tick(Context context) {
        if (this.effects.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<StatusEffectType<?>, StatusEffect>> it = this.effects.entrySet().iterator();
        ArrayList<StatusEffect> newEffects = new ArrayList<StatusEffect>();
        while (it.hasNext()) {
            StatusEffect effect = it.next().getValue();
            if (!effect.isActive()) {
                int delay = effect.getDelay();
                effect.setDelay(--delay);
                continue;
            }
            effect.apply(context);
            if (effect.isInfinite()) continue;
            int newDuration = effect.getDuration() - 1;
            effect.setDuration(newDuration);
            if (newDuration > 0) continue;
            it.remove();
            StatusEffect statusEffect = effect.onRemoved(context);
            if (statusEffect == null) continue;
            newEffects.add(statusEffect);
        }
        newEffects.forEach(this::addEffect);
    }

    public <T extends StatusEffect> void addEffect(T effect) {
        StatusEffectType<?> type = Objects.requireNonNull(effect.getType());
        this.effects.merge(type, effect, (a, b) -> type.merge(a, b));
    }

    @Nullable
    public <T extends StatusEffect> T replace(T effect) {
        return (T)this.effects.put(effect.getType(), effect);
    }

    public <T extends StatusEffect> boolean hasEffect(StatusEffectType<T> type) {
        StatusEffect effect = this.effects.get(type);
        return effect != null && effect.isActive();
    }

    public <T extends StatusEffect> boolean hasEffect(Supplier<StatusEffectType<T>> type) {
        return this.hasEffect(type.get());
    }

    public <T extends StatusEffect> boolean hasEffect(Holder<StatusEffectType<?>> holder) {
        return this.hasEffect((StatusEffectType)holder.value());
    }

    public <T extends StatusEffect> Optional<T> getEffect(StatusEffectType<T> type) {
        return Optional.ofNullable(this.effects.get(type));
    }

    public <T extends StatusEffect> Optional<T> getEffect(Supplier<StatusEffectType<T>> type) {
        return this.getEffect(type.get());
    }

    public <T extends StatusEffect> Optional<T> getEffect(Holder<StatusEffectType<?>> holder) {
        return this.getEffect((StatusEffectType)holder.value());
    }

    public void removeAll(Context context) {
        ArrayList keys = new ArrayList(this.effects.keySet());
        for (StatusEffectType statusEffectType : keys) {
            this.remove(statusEffectType, context);
        }
    }

    public StatusEffect remove(StatusEffectType<?> type, Context context) {
        StatusEffect effect = this.effects.remove(type);
        if (effect != null) {
            return effect.onRemoved(context);
        }
        return null;
    }

    public Collection<StatusEffect> listEffects() {
        return this.effects.values();
    }

    public Stream<StatusEffect> getEffectsStream() {
        return this.listEffects().stream();
    }

    @Override
    @NotNull
    public Iterator<StatusEffect> iterator() {
        return this.listEffects().iterator();
    }
}

