/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import tnt.tarkovcraft.core.common.Notification;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.util.helper.TextHelper;
import tnt.tarkovcraft.medsystem.api.heal.DeadLimbHealing;
import tnt.tarkovcraft.medsystem.api.heal.EffectRecovery;
import tnt.tarkovcraft.medsystem.api.heal.HealItemAttributes;
import tnt.tarkovcraft.medsystem.api.heal.HealthRecovery;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectProcessor;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.network.message.S2C_OpenBodyPartSelectScreen;

public class HealingItem
extends Item
implements SideEffectProcessor {
    private final ItemUseAnimation useAnimation;

    public HealingItem(ItemUseAnimation animation, Item.Properties properties) {
        super(properties);
        this.useAnimation = animation;
    }

    public HealingItem(Item.Properties properties) {
        this(ItemUseAnimation.BOW, properties);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!this.canUseItem(stack, livingEntity)) {
            stack.remove(MedSystemItemComponents.SELECTED_BODY_PART);
            livingEntity.stopUsingItem();
            return;
        }
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        HealthRecovery healthRecovery = attributes.health();
        if (healthRecovery == null) {
            return;
        }
        int usageTimeElapsed = attributes.getUseDuration(72000) - remainingUseDuration + 1;
        if (usageTimeElapsed % healthRecovery.cycleDuration() == 0) {
            int cycleLimit = healthRecovery.maxCycles() == 0 ? Integer.MAX_VALUE : healthRecovery.cycleDuration();
            int cycleIndex = usageTimeElapsed / healthRecovery.cycleDuration();
            if (cycleIndex <= cycleLimit) {
                float leftover;
                float amount = healthRecovery.healthPerCycle();
                HealthContainer container = HealthSystem.getHealthData(livingEntity);
                String partId = this.getSelectedBodyPart(stack);
                BodyPart part = TextHelper.isNotBlank((String)partId) && container.hasBodyPart(partId) ? container.getBodyPart(partId) : null;
                Level level2 = livingEntity.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.HEALING_USED, (Entity)livingEntity);
                    if (stack.isDamageableItem()) {
                        stack.hurtAndBreak(1, serverLevel, livingEntity, item -> livingEntity.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
                    } else {
                        stack.consume(1, livingEntity);
                    }
                }
                if ((leftover = container.heal(livingEntity, amount, part)) == amount) {
                    livingEntity.useItemRemaining = 0;
                }
                if (leftover > 0.0f && container.canHeal(null, false)) {
                    container.heal(livingEntity, amount, null);
                }
                container.updateHealth(livingEntity);
                if (cycleIndex + 1 > cycleLimit) {
                    livingEntity.useItemRemaining = 0;
                } else {
                    HealthSystem.synchronizeEntity(livingEntity);
                }
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        String targetLimb = this.getTargetLimb(stack);
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        if (!this.canUseItem(stack, livingEntity) || !attributes.applyGlobally() && TextHelper.isBlank((String)targetLimb)) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                Notification notification = Notification.error((Component)Component.literal((String)"Unable to use item, target limb not found"));
                notification.send(player);
            }
            return stack;
        }
        HealthContainer container = HealthSystem.getHealthData(livingEntity);
        BodyPart part = TextHelper.isNotBlank((String)targetLimb) && container.hasBodyPart(targetLimb) ? container.getBodyPart(targetLimb) : null;
        int consume = 0;
        if (attributes.canHealDeadLimbs()) {
            DeadLimbHealing deadLimbHealing = attributes.deadLimbHealing();
            ++consume;
            if (part.isDead()) {
                SkillSystem.trigger(MedSystemSkillEvents.LIMB_FIXED, (Entity)livingEntity);
                part.setHealth(deadLimbHealing.healthAfterHeal());
                deadLimbHealing.addRecoveryAttributes(livingEntity, part);
            }
        }
        List<EffectRecovery> recoveries = attributes.recoveries();
        for (EffectRecovery recovery : recoveries) {
            if (!recovery.canRecover(container, part) || !HealingItem.checkDurability(stack, consume + recovery.consumption())) continue;
            recovery.recover(livingEntity, container, stack, part);
            consume += recovery.consumption();
        }
        if (stack.has(MedSystemItemComponents.SIDE_EFFECTS)) {
            SideEffectHolder holder = (SideEffectHolder)stack.get(MedSystemItemComponents.SIDE_EFFECTS);
            holder.apply(livingEntity, container, part);
        }
        if (!level.isClientSide()) {
            int consumeAmount = Math.max(1, consume);
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.HEALING_USED, (Entity)livingEntity, (float)consumeAmount);
            if (stack.isDamageableItem()) {
                stack.hurtAndBreak(consumeAmount, (ServerLevel)level, livingEntity, item -> livingEntity.onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            } else {
                stack.consume(1, livingEntity);
            }
        }
        stack.remove(MedSystemItemComponents.SELECTED_BODY_PART);
        container.updateHealth(livingEntity);
        HealthSystem.synchronizeEntity(livingEntity);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemCooldowns cooldowns = player.getCooldowns();
            cooldowns.addCooldown(stack, 10);
        }
        return stack;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.canUseItem(stack, (LivingEntity)player)) {
            String selectedBodyPart = this.getSelectedBodyPart(stack);
            HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
            if (attributes.applyGlobally() || !player.isCrouching() && selectedBodyPart != null && ((HealthContainer)player.getData(MedSystemDataAttachments.HEALTH_CONTAINER)).hasBodyPart(selectedBodyPart)) {
                player.startUsingItem(hand);
                return InteractionResult.SUCCESS;
            }
            if (!level.isClientSide()) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2C_OpenBodyPartSelectScreen(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        return attributes.getUseDuration(72000);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return this.useAnimation;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public int getBarColor(ItemStack stack) {
        return 0xFF0000;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        int max = Math.max(stack.getMaxDamage(), 1);
        int damage = max - stack.getDamageValue();
        MutableComponent durability = Component.literal((String)(damage + "/" + max)).withStyle(ChatFormatting.RED);
        tooltipAdder.accept((Component)Component.translatable((String)"tooltip.medsystem.item.durability", (Object[])new Object[]{durability}).withStyle(ChatFormatting.GRAY));
    }

    public final String getSelectedBodyPart(ItemStack stack) {
        return (String)stack.get(MedSystemItemComponents.SELECTED_BODY_PART);
    }

    public boolean canUseItem(ItemStack stack, LivingEntity entity) {
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return false;
        }
        if (!stack.has(MedSystemItemComponents.HEAL_ATTRIBUTES)) {
            return false;
        }
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        return attributes.canUseOn(entity, stack, HealthSystem.getHealthData(entity));
    }

    protected String getTargetLimb(ItemStack stack) {
        return (String)stack.get(MedSystemItemComponents.SELECTED_BODY_PART);
    }

    public static boolean checkDurability(ItemStack stack, int durabilityUse) {
        int maxDamage = Math.max(stack.getMaxDamage(), 1) - stack.getDamageValue();
        return durabilityUse <= maxDamage;
    }
}

