/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ConfigGroupScreen
extends Screen {
    protected final Screen last;
    protected final String groupId;
    protected final List<ConfigHolder<?>> configHolders;
    protected int index;
    protected int pageSize;

    public ConfigGroupScreen(Screen last, String groupId, List<ConfigHolder<?>> configHolders) {
        super((Component)Component.translatable((String)"text.configuration.screen.select_config"));
        this.last = last;
        this.groupId = groupId;
        this.configHolders = configHolders;
    }

    protected void init() {
        int viewportMin = 35;
        int viewportHeight = this.height - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.configHolders.size());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        int posX = 30;
        int componentWidth = this.width - 2 * posX;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.configHolders.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigHolder<?> value = this.configHolders.get(i);
            int y = 45 + j * 25 + (offset += correct);
            String configId = value.getConfigId();
            this.addRenderableWidget((GuiEventListener)new LeftAlignedLabel(posX, y, componentWidth, 20, (Component)Component.translatable((String)("config.screen." + configId)), this.font));
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)ConfigEntryWidget.OPEN, btn -> {
                ConfigScreen screen = new ConfigScreen(value, value.getTitle(), value.getValueMap(), this);
                this.minecraft.setScreen((Screen)screen);
            }).pos(ConfigGroupScreen.getValueX(posX, componentWidth), y).size(ConfigGroupScreen.getValueWidth(componentWidth), 20).build());
        }
        this.initFooter();
    }

    static int getValueX(int x, int width) {
        return x + width - ConfigGroupScreen.getValueWidth(width);
    }

    static int getValueWidth(int width) {
        return width / 3;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int titleWidth = this.font.width((FormattedText)this.title);
        graphics.fill(0, 0, this.width, 35, -1728053248);
        int n = (this.width - titleWidth) / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.title, n, (35 - 9) / 2, -1);
        graphics.fill(0, this.height - 30, this.width, this.height, -1728053248);
        graphics.fill(0, 35, this.width, this.height - 30, 0x55000000);
        AbstractConfigScreen.renderScrollbar(graphics, this.width - 5, 35, 5, this.height - 30 - 35, this.index, this.configHolders.size(), this.pageSize, -16777216);
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTicks));
    }

    protected void initFooter() {
        int centerY = this.height - 30 + 5;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)AbstractConfigScreen.LABEL_BACK, btn -> this.minecraft.setScreen(this.last)).pos(5, centerY).size(120, 20).build());
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        int scale = (int)(-amountY);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
            this.index = next;
            this.init(this.minecraft, this.width, this.height);
            return true;
        }
        return false;
    }

    protected static final class LeftAlignedLabel
    extends AbstractWidget {
        private final Font font;

        public LeftAlignedLabel(int x, int y, int width, int height, Component label, Font font) {
            super(x, y, width, height, label);
            this.font = font;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            Component component = this.getMessage();
            int n = this.getX();
            int n2 = this.getY();
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, component, n, n2 + (this.height - 9) / 2, -5592406);
        }

        protected boolean isValidClickButton(int p_230987_1_) {
            return false;
        }

        public boolean isMouseOver(double $$0, double $$1) {
            return false;
        }

        protected void updateWidgetNarration(NarrationElementOutput output) {
        }
    }
}

