/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class DialogScreen
extends Screen {
    public static final Component TEXT_CONFIRM = Component.translatable((String)"text.configuration.screen.dialog.confirm");
    public static final Component TEXT_CANCEL = Component.translatable((String)"text.configuration.screen.dialog.cancel");
    private final Screen background;
    private DialogRespondEvent onCancel;
    private DialogRespondEvent onConfirm;
    protected final Component[] text;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    private List<FormattedCharSequence> splitText = new ArrayList<FormattedCharSequence>();

    public DialogScreen(Component title, Component[] text, Screen background) {
        super(title);
        this.text = text;
        this.background = background;
        this.onCancel = screen -> this.displayPreviousScreen();
        this.onConfirm = screen -> this.displayPreviousScreen();
    }

    public void onCancelled(DialogRespondEvent cancelEvent) {
        this.onCancel = Objects.requireNonNull(cancelEvent);
    }

    public void onConfirmed(DialogRespondEvent confirmEvent) {
        this.onConfirm = Objects.requireNonNull(confirmEvent);
    }

    public void setDimensions(int dialogWidth, int dialogHeight) {
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.dialogLeft = (this.width - this.dialogWidth) / 2;
        this.dialogTop = (this.height - this.dialogHeight) / 2;
        this.splitText = Arrays.stream(this.text).map(line -> this.font.split((FormattedText)line, this.dialogWidth - 10)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected void init() {
        this.background.init(this.minecraft, this.width, this.height);
        this.setDimensions(140, 100);
        this.addDefaultDialogButtons();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int backgroundColor = -16777216;
        this.background.render(graphics, -1, -1, partialTicks);
        graphics.nextStratum();
        graphics.fill(0, 0, this.width, this.height, -1442840576);
        graphics.fillGradient(this.dialogLeft - 1, this.dialogTop - 1, this.dialogLeft + this.dialogWidth + 1, this.dialogTop + this.dialogHeight + 1, -1, -1);
        graphics.fillGradient(this.dialogLeft, this.dialogTop, this.dialogLeft + this.dialogWidth, this.dialogTop + this.dialogHeight, backgroundColor, backgroundColor);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        this.renderables.forEach(renderable -> renderable.render(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.allowKeyboardInteractions()) {
            if (keyCode == 256) {
                this.cancel();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.confirm();
                return true;
            }
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics p_283688_, int p_299421_, int p_298679_, float p_297268_) {
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int headerWidth = this.font.width((FormattedText)this.title);
        graphics.drawString(this.font, this.title, this.dialogLeft + (this.dialogWidth - headerWidth) / 2, this.dialogTop + 5, -1);
        int line = 0;
        for (FormattedCharSequence textLine : this.splitText) {
            graphics.drawString(this.font, textLine, this.dialogLeft + 5, this.dialogTop + 20 + line * 10, -1);
            ++line;
        }
    }

    protected void addDefaultDialogButtons() {
        int useableWidth = this.dialogWidth - 15;
        int componentWidth = useableWidth / 2;
        int cancelX = this.dialogLeft + 5;
        int confirmX = this.dialogLeft + this.dialogWidth - 5 - componentWidth;
        int componentY = this.dialogTop + this.dialogHeight - 25;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TEXT_CANCEL, btn -> this.cancel()).pos(cancelX, componentY).size(componentWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TEXT_CONFIRM, btn -> this.confirm()).pos(confirmX, componentY).size(componentWidth, 20).build());
    }

    protected void confirm() {
        this.onConfirm.respond(this);
    }

    protected void cancel() {
        this.onCancel.respond(this);
    }

    public void displayPreviousScreen() {
        this.minecraft.setScreen(this.background);
    }

    protected boolean allowKeyboardInteractions() {
        return true;
    }

    @FunctionalInterface
    public static interface DialogRespondEvent {
        public void respond(DialogScreen var1);
    }
}

