/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.config.validate.ValidationResult;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface IValidationResult {
    public Severity severity();

    public List<Component> messages();

    public static IValidationResult success() {
        return ValidationResult.SUCCESS;
    }

    public static IValidationResult warning(List<Component> messages) {
        return new ValidationResult(Severity.WARNING, messages);
    }

    public static IValidationResult warning(Component message) {
        return IValidationResult.warning(Collections.singletonList(message));
    }

    public static IValidationResult error(List<Component> messages) {
        return new ValidationResult(Severity.ERROR, messages);
    }

    public static IValidationResult error(Component message) {
        return IValidationResult.error(Collections.singletonList(message));
    }

    public static enum Severity {
        NONE(-1, -268238055, 1344574437, 1344563685),
        WARNING(-22016, -262784768, 1358934528, 1352558848),
        ERROR(-43691, -265879546, 0x50FF0000, 0x50880000);

        public final int textColor;
        public final int backgroundColor;
        public final int backgroundFadeMinColor;
        public final int backgroundFadeMaxColor;
        public final ResourceLocation iconPath;

        private Severity(int textColor, int backgroundColor, int backgroundFadeMinColor, int backgroundFadeMaxColor) {
            this.textColor = textColor;
            this.backgroundColor = backgroundColor;
            this.backgroundFadeMinColor = backgroundFadeMinColor;
            this.backgroundFadeMaxColor = backgroundFadeMaxColor;
            this.iconPath = ResourceLocation.fromNamespaceAndPath((String)"configuration", (String)("textures/icons/" + this.name().toLowerCase(Locale.ROOT) + ".png"));
        }

        public boolean isWarningOrError() {
            return this != NONE;
        }

        public boolean isValid() {
            return this != ERROR;
        }

        public boolean isHigherSeverityThan(Severity other) {
            return this.ordinal() > other.ordinal();
        }
    }
}

