/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.validate.NumberRange;
import dev.toma.configuration.config.value.AbstractArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IConfigValueReadable;
import dev.toma.configuration.config.value.NumericArrayValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;

public class FloatArrayValue
extends NumericArrayValue<Float> {
    public FloatArrayValue(ValueData<Float[]> valueData) {
        super(valueData, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
    }

    @Override
    public NumberRange<Float> getValueRange(Field field) {
        Configurable.DecimalRange decimalRange = field.getAnnotation(Configurable.DecimalRange.class);
        return decimalRange != null ? NumberRange.interval(this, Float.valueOf((float)Math.max((double)((Float)this.min()).floatValue(), decimalRange.min())), Float.valueOf((float)Math.min(decimalRange.max(), (double)((Float)this.max()).floatValue()))) : NumberRange.all(this);
    }

    @Override
    public Float createElementInstance() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeFloatArray(this.getId(), (Float[])this.get(IConfigValueReadable.Mode.SAVED));
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.setValue(format.readFloatArray(this.getId()));
    }

    public static final class Adapter
    extends TypeAdapter<Float[]> {
        @Override
        public void encodeToBuffer(ConfigValue<Float[]> value, FriendlyByteBuf buffer) {
            AbstractArrayValue.saveToBuffer(value.get(), buffer, FriendlyByteBuf::writeFloat);
        }

        @Override
        public Float[] decodeFromBuffer(ConfigValue<Float[]> value, FriendlyByteBuf buffer) {
            return AbstractArrayValue.readFromBuffer(buffer, Float[]::new, FriendlyByteBuf::readFloat);
        }

        @Override
        public ConfigValue<Float[]> serialize(TypeAdapter.TypeAttributes<Float[]> attributes, Object instance, TypeAdapter.TypeSerializer serializer) throws IllegalAccessException {
            return new FloatArrayValue(ValueData.of(attributes));
        }
    }
}

