/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.client.TarkovCraftCoreClientEventHandler;
import tnt.tarkovcraft.core.client.config.TarkovCraftCoreClientConfig;
import tnt.tarkovcraft.core.client.notification.NotificationChannel;
import tnt.tarkovcraft.core.client.notification.NotificationLayer;
import tnt.tarkovcraft.core.client.overlay.DebugLayer;
import tnt.tarkovcraft.core.client.overlay.StaminaLayer;
import tnt.tarkovcraft.core.client.screen.DataScreen;
import tnt.tarkovcraft.core.client.screen.navigation.CoreNavigators;
import tnt.tarkovcraft.core.network.Synchronizable;
import tnt.tarkovcraft.core.util.context.ContextImpl;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.core.util.helper.TextHelper;

@Mod(value="tarkovcraft_core", dist={Dist.CLIENT})
public final class TarkovCraftCoreClient {
    public static final KeyMapping KEY_CHARACTER = new KeyMapping(TextHelper.createKeybindName("tarkovcraft_core", "character"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 79, "category.tarkovcraft");
    private static TarkovCraftCoreClientConfig config;

    public TarkovCraftCoreClient(IEventBus modEventBus, ModContainer container) {
        config = (TarkovCraftCoreClientConfig)Configuration.registerConfig(TarkovCraftCoreClientConfig.class, (IConfigFormatHandler)ConfigFormats.YAML).getConfigInstance();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::registerKeyBindings);
        modEventBus.addListener(this::registerCustomGuiLayers);
        NeoForge.EVENT_BUS.addListener(this::onKeyboardInput);
        NeoForge.EVENT_BUS.register((Object)new TarkovCraftCoreClientEventHandler());
    }

    public static TarkovCraftCoreClientConfig getConfig() {
        return config;
    }

    private void dispatchParallelRegistryEvents() {
    }

    private void setup(FMLClientSetupEvent event) {
        this.dispatchParallelRegistryEvents();
    }

    private void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(KEY_CHARACTER);
    }

    private void onKeyboardInput(InputEvent.Key event) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player != null && KEY_CHARACTER.consumeClick()) {
            ContextImpl context = ContextImpl.of(ContextKeys.UUID, player.getUUID());
            client.setScreen(CoreNavigators.CHARACTER_NAVIGATION_PROVIDER.buildInitial(context));
        }
    }

    private void registerCustomGuiLayers(RegisterGuiLayersEvent event) {
        if (!FMLEnvironment.production) {
            event.registerAboveAll(DebugLayer.LAYER_ID, (GuiLayer)new DebugLayer());
        }
        event.registerAboveAll(NotificationLayer.LAYER_ID, (GuiLayer)new NotificationLayer(NotificationChannel.MAIN));
        event.registerAboveAll(StaminaLayer.LAYER_ID, (GuiLayer)new StaminaLayer());
    }

    public static void sendDataSyncEvent(Entity entity, AttachmentType<?> type, Synchronizable<?> data) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof DataScreen) {
            DataScreen dataScreen = (DataScreen)screen;
            dataScreen.onAttachmentDataReceived(entity, type, data);
        }
    }
}

