/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.widget;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import tnt.tarkovcraft.core.client.screen.listener.ScrollChangeListener;
import tnt.tarkovcraft.core.common.mail.MailList;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class ChatMessagesWidget
extends AbstractWidget {
    private final UUID me;
    private final Font font;
    private final MailList chat;
    private final List<Message> compiledMessages = new ArrayList<Message>();
    private int backgroundColor;
    private ScrollChangeListener scrollChangeListener;
    private double scrollAmount;

    public ChatMessagesWidget(int x, int y, int width, int height, UUID me, Font font, MailList chat) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.me = me;
        this.font = font;
        this.chat = chat;
        List<MailMessage> mailMessages = this.chat.listMessages();
        for (int i = mailMessages.size() - 1; i >= 0; --i) {
            MailMessage message = mailMessages.get(i);
            Component text = message.getContent();
            SequencedCollection formattedText = this.font.split((FormattedText)text, this.width - 4).stream().map(seq -> new Message(message.getMessageReceptionTime(), message.getSender(), (FormattedCharSequence)seq)).toList().reversed();
            this.compiledMessages.addAll(formattedText);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public void setScrollChangeListener(ScrollChangeListener scrollChangeListener) {
        this.scrollChangeListener = scrollChangeListener;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int index = (int)(this.scrollAmount / 10.0);
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        if (RenderUtils.isVisibleColor(this.backgroundColor)) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), this.backgroundColor);
        }
        int y = (int)((float)(this.getBottom() - 10) + (float)(this.scrollAmount - (double)((float)index * 10.0f)));
        for (int i = index; i < this.compiledMessages.size(); ++i) {
            Message message = this.compiledMessages.get(i);
            boolean isMine = this.me.equals(message.owner);
            if (isMine) {
                int width = this.font.width(message.text());
                guiGraphics.drawString(this.font, message.text(), this.getRight() - 2 - width, y, -2039584, false);
            } else {
                guiGraphics.drawString(this.font, message.text(), this.getX() + 2, y, -9408400, false);
            }
            if ((y -= 10) < this.getY()) break;
        }
        guiGraphics.disableScissor();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        List<MailMessage> messages = this.chat.listMessages();
        if (messages.isEmpty()) {
            return false;
        }
        int messageCount = messages.size() - 1;
        this.scrollAmount = Math.clamp(this.scrollAmount + scrollY, 0.0, (double)(messageCount * 10));
        if (this.scrollChangeListener != null) {
            this.scrollChangeListener.onScrollChange(scrollX, this.scrollAmount);
        }
        return true;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private record Message(ZonedDateTime ts, UUID owner, FormattedCharSequence text) {
    }
}

