/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;

public final class AttributeSystem {
    public static boolean isEnabledForEntity(Entity entity) {
        return entity != null && (entity.getType() == EntityType.PLAYER || entity.hasData(CoreDataAttachments.ENTITY_ATTRIBUTES));
    }

    public static EntityAttributeData getAttributes(Entity entity) {
        return (EntityAttributeData)entity.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
    }

    public static boolean getBooleanValue(Entity entity, Holder<Attribute> attribute, boolean defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::booleanValue, Boolean.valueOf(defaultValue));
    }

    public static int getIntValue(Entity entity, Holder<Attribute> attribute, int defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::intValue, Integer.valueOf(defaultValue));
    }

    public static float getFloatValue(Entity entity, Holder<Attribute> attribute, float defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::floatValue, Float.valueOf(defaultValue)).floatValue();
    }

    public static double getDoubleValue(Entity entity, Holder<Attribute> attribute, double defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::value, Double.valueOf(defaultValue));
    }

    public static boolean getBooleanValue(Entity entity, Supplier<Attribute> attribute, boolean defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::booleanValue, Boolean.valueOf(defaultValue));
    }

    public static int getIntValue(Entity entity, Supplier<Attribute> attribute, int defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::intValue, Integer.valueOf(defaultValue));
    }

    public static float getFloatValue(Entity entity, Supplier<Attribute> attribute, float defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::floatValue, Float.valueOf(defaultValue)).floatValue();
    }

    public static double getDoubleValue(Entity entity, Supplier<Attribute> attribute, double defaultValue) {
        return AttributeSystem.getValue(entity, attribute, AttributeInstance::value, Double.valueOf(defaultValue));
    }

    public static <T> T getValue(Entity entity, Supplier<Attribute> attribute, Function<AttributeInstance, T> getter, T defaultValue) {
        return AttributeSystem.getValue(entity, attribute.get(), getter, defaultValue);
    }

    public static <T> T getValue(Entity entity, Holder<Attribute> attribute, Function<AttributeInstance, T> getter, T defaultValue) {
        return AttributeSystem.getValue(entity, (Attribute)attribute.value(), getter, defaultValue);
    }

    public static <T> T getValue(Entity entity, Attribute attribute, Function<AttributeInstance, T> getter, T defaultValue) {
        if (AttributeSystem.isEnabledForEntity(entity)) {
            EntityAttributeData data = AttributeSystem.getAttributes(entity);
            AttributeInstance instance = data.getAttribute(attribute);
            return getter.apply(instance);
        }
        return defaultValue;
    }
}

