/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.api.event.EntityAttributeEvent;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.SynchronizationAttributeListener;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.network.Synchronizable;

public final class EntityAttributeData
implements Synchronizable<EntityAttributeData> {
    public static final MapCodec<EntityAttributeData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)CoreRegistries.ATTRIBUTE.byNameCodec(), AttributeInstance.CODEC).fieldOf("attributeMap").forGetter(t -> t.attributeMap)).apply((Applicative)instance, EntityAttributeData::new));
    public static final Codec<EntityAttributeData> CODEC = MAP_CODEC.codec();
    private Entity holder;
    private final Map<Attribute, AttributeInstance> attributeMap;

    public EntityAttributeData(IAttachmentHolder holder) {
        this.attributeMap = new HashMap<Attribute, AttributeInstance>();
        this.setHolder(holder);
    }

    private EntityAttributeData(Map<Attribute, AttributeInstance> attributeMap) {
        this.attributeMap = new HashMap<Attribute, AttributeInstance>(attributeMap);
        this.attributeMap.values().forEach(this::addAttributeListeners);
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.attributeMap.computeIfAbsent(attribute, this::createInstance);
    }

    public AttributeInstance getAttribute(Holder<Attribute> reference) {
        return this.getAttribute((Attribute)reference.value());
    }

    public AttributeInstance getAttribute(Supplier<Attribute> attribute) {
        return this.getAttribute(attribute.get());
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributeMap.containsKey(attribute);
    }

    public void update() {
        for (AttributeInstance value : this.attributeMap.values()) {
            value.update();
        }
    }

    public void setHolder(IAttachmentHolder holder) {
        if (!(holder instanceof Entity)) {
            throw new IllegalArgumentException("Holder must be an instance of Entity");
        }
        this.holder = (Entity)holder;
        this.addAttributeListeners(this.attributeMap.values());
    }

    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public Codec<EntityAttributeData> networkCodec() {
        return CODEC;
    }

    private AttributeInstance createInstance(Attribute attribute) {
        AttributeInstance instance = attribute.createInstance(this.holder);
        this.addAttributeListeners(instance);
        return instance;
    }

    private void addAttributeListeners(Collection<AttributeInstance> collection) {
        collection.forEach(this::addAttributeListeners);
    }

    private void addAttributeListeners(AttributeInstance instance) {
        if (this.holder == null) {
            return;
        }
        Entity entity = this.holder;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            instance.addListener(new SynchronizationAttributeListener(serverPlayer));
        }
        NeoForge.EVENT_BUS.post((Event)new EntityAttributeEvent.AttributeInstanceConstructing(this, instance.getAttribute(), instance));
    }
}

