/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifierType;
import tnt.tarkovcraft.core.common.init.CoreAttributeModifiers;

public class SetValueAttributeModifier
extends AttributeModifier {
    public static final MapCodec<SetValueAttributeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(AttributeModifier::identifier), (App)Codec.DOUBLE.fieldOf("value").forGetter(t -> t.value), (App)Codec.INT.optionalFieldOf("order", (Object)100).forGetter(t -> t.order)).apply((Applicative)instance, SetValueAttributeModifier::new));
    private final double value;
    private final int order;

    public SetValueAttributeModifier(UUID identifier, double value) {
        this(identifier, value, 100);
    }

    public SetValueAttributeModifier(UUID identifier, double value, int order) {
        super(identifier);
        this.value = value;
        this.order = order;
    }

    @Override
    public double calculateValue(AttributeInstance source, double value) {
        return this.value;
    }

    @Override
    public int ordering() {
        return this.order;
    }

    @Override
    public AttributeModifierType<?> getType() {
        return CoreAttributeModifiers.SET_VALUE.get();
    }

    public String toString() {
        return String.format("SetValue=[value=%f]", this.value);
    }
}

