/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.data.duration;

import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatSettings;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatter;
import tnt.tarkovcraft.core.common.data.duration.Unit;

public enum DurationFormats implements DurationFormatter
{
    LONG_NAME(DurationFormats::formatFullNameDuration),
    SHORT_NAME(DurationFormats::formatUnitNameDuration),
    TIME(DurationFormats::formatTimeDuration);

    private final DurationFormatter formatter;

    private DurationFormats(DurationFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public String toLocalizedString(DurationFormatSettings settings, int value) {
        return this.formatter.toLocalizedString(settings, value);
    }

    public static String formatFullNameDuration(DurationFormatSettings settings, int value) {
        return DurationFormats.format(settings, value, (unit, unitValue) -> " " + unit.getLocalizedName((String)unitValue).getString(), UnaryOperator.identity());
    }

    public static String formatUnitNameDuration(DurationFormatSettings settings, int value) {
        return DurationFormats.format(settings, value, (unit, unitValue) -> unitValue + unit.getShortName().getString(), UnaryOperator.identity());
    }

    public static String formatTimeDuration(DurationFormatSettings settings, int value) {
        settings.setNumberFormat(val -> StringUtils.leftPad((String)String.valueOf(val), (int)2, (String)"0"));
        return DurationFormats.format(settings, value, (unit, unitValue) -> " " + unitValue, out -> out.replaceAll("\\s+", ":"));
    }

    public static String format(DurationFormatSettings settings, int value, BiFunction<Unit, String, String> output, UnaryOperator<String> post) {
        StringBuilder builder = new StringBuilder();
        for (Unit unit : settings.getUnits()) {
            int unitValue = value / unit.value();
            if (unitValue > 0 || settings.isIncludeZeroValues()) {
                String strValue = settings.getNumberFormat().apply(unitValue);
                builder.append(output.apply(unit, strValue));
            }
            value %= unit.value();
        }
        String out = builder.toString().trim();
        return (String)post.apply(out);
    }
}

