/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailSource;

public final class MailList
implements Comparable<MailList> {
    public static final Codec<MailList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MailSource.CODEC.fieldOf("src").forGetter(t -> t.source), (App)MailMessage.CODEC.listOf().fieldOf("msg").forGetter(t -> t.messages), (App)Codec.BOOL.fieldOf("pin").forGetter(t -> t.pinned)).apply((Applicative)instance, MailList::new));
    private final MailSource source;
    private final List<MailMessage> messages;
    private boolean pinned;

    private MailList(MailSource source, List<MailMessage> messages, boolean pinned) {
        this.source = source;
        this.messages = new ArrayList<MailMessage>(messages);
        this.pinned = pinned;
    }

    public MailList(MailSource source) {
        this(source, new ArrayList<MailMessage>(), false);
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public String getMessageCount() {
        return this.messages.size() > 99 ? "[99+]" : String.format("[%d]", this.messages.size());
    }

    public void receive(MailMessage message) {
        this.send(message);
    }

    public void send(MailMessage message) {
        this.messages.add(message);
    }

    public void delete(MailMessage message) {
        this.messages.remove(message);
    }

    public MailSource getSource() {
        return this.source;
    }

    public List<MailMessage> listMessages() {
        return this.messages;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public ZonedDateTime getLastMessageTime() {
        return this.messages.isEmpty() ? null : this.messages.getLast().getMessageReceptionTime();
    }

    public boolean hasAttachments() {
        return this.messages.stream().anyMatch(MailMessage::hasAttachments);
    }

    @Override
    public int compareTo(@NotNull MailList o) {
        if (this.pinned != o.pinned) {
            return this.pinned ? -1 : 1;
        }
        return Comparator.nullsLast(ChronoZonedDateTime::compareTo).compare(this.getLastMessageTime(), o.getLastMessageTime());
    }
}

