/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import tnt.tarkovcraft.core.common.mail.MailList;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.network.Synchronizable;

public final class MailManager
implements Synchronizable<MailManager> {
    public static final MapCodec<MailManager> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MailList.CODEC.listOf().fieldOf("chat").forGetter(t -> new ArrayList<MailList>(t.messages.values())), (App)UUIDUtil.STRING_CODEC.listOf().fieldOf("blocked").forGetter(t -> new ArrayList<UUID>(t.blockedIds))).apply((Applicative)instance, MailManager::resolve));
    public static final Codec<MailManager> CODEC = MAP_CODEC.codec();
    private final Map<MailSource, MailList> messages = new HashMap<MailSource, MailList>();
    private final Set<UUID> blockedIds = new HashSet<UUID>();

    private static MailManager resolve(List<MailList> chats, List<UUID> blockedIds) {
        MailManager result = new MailManager();
        for (MailList chat : chats) {
            result.messages.put(chat.getSource(), chat);
        }
        result.blockedIds.addAll(blockedIds);
        return result;
    }

    public void sendMessage(MailSource source, MailMessage message) {
        this.getChat(source).send(message);
    }

    public void block(UUID id) {
        this.blockedIds.add(id);
    }

    public void unblock(UUID id) {
        this.blockedIds.remove(id);
    }

    public boolean isBlocked(MailSource source) {
        return !source.isSystemChat() && this.blockedIds.contains(source.getSourceId());
    }

    public void receiveMessage(MailSource source, MailMessage message) {
        if (!this.isBlocked(source)) {
            this.getChat(source).receive(message);
        }
    }

    public void removeMessage(MailSource source, MailMessage message) {
        if (this.messages.containsKey(source)) {
            MailList mailList = this.messages.get(source);
            mailList.delete(message);
        }
    }

    public Collection<MailList> listChats() {
        return this.messages.values();
    }

    public MailList getChat(MailSource source) {
        return this.messages.computeIfAbsent(source, MailList::new);
    }

    public MailList deleteChat(MailSource source) {
        return this.messages.remove(source);
    }

    public MailSource getSender(UUID id) {
        for (MailSource src : this.messages.keySet()) {
            if (!src.getSourceId().equals(id)) continue;
            return src;
        }
        return null;
    }

    public boolean hasChat(MailSource source) {
        return this.messages.containsKey(source);
    }

    public boolean hasAttachments(MailSource source) {
        if (!this.messages.containsKey(source)) {
            return false;
        }
        MailList chat = this.getChat(source);
        return chat.hasAttachments();
    }

    @Override
    public Codec<MailManager> networkCodec() {
        return CODEC;
    }
}

