/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.IntConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.SkillLevelDefinition;
import tnt.tarkovcraft.core.common.skill.SkillMemoryConfiguration;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerDefinition;
import tnt.tarkovcraft.core.util.context.Context;

public final class Skill {
    public static final Codec<Skill> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkillDefinition.CODEC.fieldOf("skill").forGetter(t -> t.definition), (App)Codec.INT.fieldOf("level").forGetter(t -> t.level), (App)Codec.FLOAT.fieldOf("exp").forGetter(t -> Float.valueOf(t.experience)), (App)Codec.FLOAT.fieldOf("requiredExp").forGetter(t -> Float.valueOf(t.requiredExperience)), (App)Codec.LONG.fieldOf("lastExpUpdate").forGetter(t -> t.lastExperienceUpdate)).apply((Applicative)instance, Skill::new));
    public static final Component MAX_LEVEL = Component.translatable((String)"label.tarkovcraft_core.skill.max_level").withStyle(ChatFormatting.GOLD);
    private final Holder<SkillDefinition> definition;
    private int level;
    private float experience;
    private float requiredExperience;
    private long lastExperienceUpdate;

    Skill(Holder<SkillDefinition> definition, int level, float experience, float requiredExperience, long lastExperienceUpdate) {
        this.definition = definition;
        this.level = level;
        this.experience = experience;
        this.requiredExperience = requiredExperience;
        this.lastExperienceUpdate = lastExperienceUpdate;
    }

    public Skill(Holder<SkillDefinition> definition) {
        this(definition, 0, 0.0f, ((SkillDefinition)definition.value()).getLevelDefinition().getRequiredExperience(0), 0L);
    }

    public float trigger(Context context) {
        float triggeredAmount = 0.0f;
        for (SkillTrackerDefinition trackerDefinition : ((SkillDefinition)this.definition.value()).getTrackers()) {
            triggeredAmount += trackerDefinition.trigger(context);
        }
        return triggeredAmount;
    }

    public void updateMemory(long time, EntityAttributeData attributeData, IntConsumer levelChangeCallback) {
        SkillMemoryConfiguration memory = ((SkillDefinition)this.definition.value()).getMemory();
        if (SkillSystem.isMemoryEnabled() && memory.isEnabled()) {
            long diff = time - this.lastExperienceUpdate;
            float rateMultiplier = attributeData.getAttribute(CoreAttributes.MEMORY_FORGET_TIME_MULTIPLIER).floatValue();
            long timeToForget = (long)((float)memory.getForgetAfter() * rateMultiplier);
            long times = diff / timeToForget;
            if (times > 0L) {
                long additional = diff % timeToForget;
                float amountMultiplier = attributeData.getAttribute(CoreAttributes.MEMORY_FORGET_AMOUNT_MULTIPLIER).floatValue();
                float amount = memory.getForgetAmount() * amountMultiplier * (float)times;
                this.loseExperience(amount, memory, levelChangeCallback);
                time -= additional;
            }
        }
        this.setLastExperienceUpdate(time);
    }

    public void loseExperience(float experience, SkillMemoryConfiguration memoryConfig, IntConsumer levelChangeCallback) {
        float experienceToLose = experience > this.experience && !memoryConfig.canLoseLevel() ? this.experience : experience;
        float currentLoss = Math.min(experienceToLose, this.experience);
        float overflow = experienceToLose - currentLoss;
        this.experience -= currentLoss;
        if (SkillSystem.isLevelMemoryEnabled() && overflow > 0.0f && this.level > 0) {
            --this.level;
            this.experience = this.requiredExperience = ((SkillDefinition)this.definition.value()).getLevelDefinition().getRequiredExperience(this.level);
            levelChangeCallback.accept(this.level + 1);
            this.loseExperience(overflow, memoryConfig, levelChangeCallback);
        }
    }

    public void setLastExperienceUpdate(long lastExperienceUpdate) {
        this.lastExperienceUpdate = lastExperienceUpdate;
    }

    public void addExperience(float experience, IntConsumer levelChangeCallback) {
        float f;
        if (this.isMaxLevel() || !((SkillDefinition)this.definition.value()).isEnabled()) {
            return;
        }
        this.experience += experience;
        if (f >= this.requiredExperience) {
            ++this.level;
            float overflow = this.experience - this.requiredExperience;
            SkillLevelDefinition levelDefinition = ((SkillDefinition)this.definition.value()).getLevelDefinition();
            this.requiredExperience = levelDefinition.getRequiredExperience(this.level);
            this.experience = 0.0f;
            levelChangeCallback.accept(this.level - 1);
            this.addExperience(overflow, levelChangeCallback);
        }
    }

    public void forceSetLevel(int level) {
        this.level = level;
        this.experience = 0.0f;
        this.requiredExperience = ((SkillDefinition)this.definition.value()).getLevelDefinition().getRequiredExperience(this.level);
    }

    public int getLevel() {
        return this.level;
    }

    public int getMaxLevel() {
        return ((SkillDefinition)this.definition.value()).getLevelDefinition().getMaxLevel();
    }

    public float getExperience() {
        return this.experience;
    }

    public float getRequiredExperience() {
        return this.requiredExperience;
    }

    public boolean isMaxLevel() {
        return this.level >= this.getMaxLevel();
    }

    public Holder<SkillDefinition> getDefinition() {
        return this.definition;
    }
}

