/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.tracker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTracker;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerType;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTriggerEvent;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerCondition;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerConditionType;
import tnt.tarkovcraft.core.util.context.Context;

public record SkillTrackerDefinition(SkillTriggerEvent event, List<SkillTriggerCondition> conditions, SkillTracker tracker) {
    public static final Codec<SkillTrackerDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CoreRegistries.SKILL_TRIGGER_EVENT.byNameCodec().fieldOf("event").forGetter(SkillTrackerDefinition::event), (App)SkillTriggerConditionType.INSTANCE_CODEC.listOf().optionalFieldOf("conditions", Collections.emptyList()).forGetter(SkillTrackerDefinition::conditions), (App)SkillTrackerType.CODEC.fieldOf("tracker").forGetter(SkillTrackerDefinition::tracker)).apply((Applicative)instance, SkillTrackerDefinition::new));

    public List<Component> getInfoComponents() {
        ArrayList<Component> infoComponents = new ArrayList<Component>();
        infoComponents.add((Component)Component.translatable((String)this.event.identifier().toLanguageKey("skill.trigger", "info")).withStyle(ChatFormatting.GREEN));
        if (!this.conditions.isEmpty()) {
            infoComponents.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.tarkovcraft_core.skill.conditions")).withStyle(ChatFormatting.GRAY));
            for (SkillTriggerCondition condition : this.conditions) {
                infoComponents.add((Component)Component.literal((String)" - ").append(condition.getDescription()).withStyle(ChatFormatting.GRAY));
            }
        }
        return infoComponents;
    }

    public float trigger(Context context) {
        for (SkillTriggerCondition condition : this.conditions) {
            if (condition.isTriggerable(context)) continue;
            return 0.0f;
        }
        if (this.tracker.isTriggerable(context)) {
            return this.tracker.trigger(context);
        }
        return 0.0f;
    }
}

