/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.tracker.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.value.IConfigValueReadable;
import net.minecraft.network.chat.Component;
import tnt.tarkovcraft.core.common.init.CoreSkillTriggerConditions;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerCondition;
import tnt.tarkovcraft.core.common.skill.tracker.condition.SkillTriggerConditionType;
import tnt.tarkovcraft.core.util.context.Context;

public class ConfigToggleSkillCondition
implements SkillTriggerCondition {
    public static final MapCodec<ConfigToggleSkillCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("configId").forGetter(t -> t.configId), (App)Codec.STRING.fieldOf("configPath").forGetter(t -> t.configPath)).apply((Applicative)instance, ConfigToggleSkillCondition::new));
    private final String configId;
    private final String configPath;

    public ConfigToggleSkillCondition(String configId, String configPath) {
        this.configId = configId;
        this.configPath = configPath;
    }

    @Override
    public boolean isTriggerable(Context context) {
        return Configuration.getConfig((String)this.configId).flatMap(holder -> holder.getConfigValue(this.configPath, Boolean.class)).map(value -> (Boolean)value.get(IConfigValueReadable.Mode.SAVED)).orElse(false);
    }

    @Override
    public Component getDescription() {
        Component title = Configuration.getConfig((String)this.configId).flatMap(holder -> holder.getConfigValue(this.configPath, Boolean.class)).map(IConfigValueReadable::getTitle).orElse((Component)Component.literal((String)"???"));
        return Component.translatable((String)"skill.condition.config_toggle", (Object[])new Object[]{title});
    }

    @Override
    public SkillTriggerConditionType<?> getType() {
        return CoreSkillTriggerConditions.CONFIG_TOGGLE.get();
    }
}

