/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.statistic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.function.LongBinaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.statistic.Statistic;
import tnt.tarkovcraft.core.network.Synchronizable;
import tnt.tarkovcraft.core.network.message.S2C_SendDataAttachments;

public final class StatisticTracker
implements Synchronizable<StatisticTracker> {
    public static final MapCodec<StatisticTracker> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)CoreRegistries.STATISTICS.byNameCodec(), (Codec)Codec.LONG).fieldOf("statMap").forGetter(t -> t.stats)).apply((Applicative)instance, StatisticTracker::new));
    public static final Codec<StatisticTracker> CODEC = MAP_CODEC.codec();
    public static final ContextKey<StatisticTracker> TRACKER = new ContextKey(TarkovCraftCore.createResourceLocation("stat_tracker"));
    private final Object2LongMap<Statistic> stats;

    public StatisticTracker() {
        this.stats = new Object2LongOpenHashMap();
    }

    private StatisticTracker(Map<Statistic, Long> stats) {
        this.stats = new Object2LongOpenHashMap(stats);
    }

    public static void increment(IAttachmentHolder holder, Holder<Statistic> stat) {
        StatisticTracker.increment(holder, (Statistic)stat.value());
    }

    public static void increment(IAttachmentHolder holder, Holder<Statistic> stat, long amount) {
        StatisticTracker.increment(holder, (Statistic)stat.value(), amount);
    }

    public static void increment(IAttachmentHolder holder, Statistic stat) {
        StatisticTracker.increment(holder, stat, 1L);
    }

    public static void increment(IAttachmentHolder holder, Statistic stat, long amount) {
        ((StatisticTracker)holder.getData(CoreDataAttachments.STATISTICS)).increment(stat, amount);
        if (holder instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)holder;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.STATISTICS.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean incrementOptional(IAttachmentHolder holder, Holder<Statistic> stat) {
        return StatisticTracker.incrementOptional(holder, (Statistic)stat.value());
    }

    public static boolean incrementOptional(IAttachmentHolder holder, Holder<Statistic> stat, long amount) {
        return StatisticTracker.incrementOptional(holder, (Statistic)stat.value(), amount);
    }

    public static boolean incrementOptional(IAttachmentHolder holder, Statistic stat) {
        return StatisticTracker.incrementOptional(holder, stat, 1L);
    }

    public static boolean incrementOptional(IAttachmentHolder holder, Statistic statistic, long amount) {
        if (holder.hasData(CoreDataAttachments.STATISTICS)) {
            StatisticTracker.increment(holder, statistic, amount);
            return true;
        }
        return false;
    }

    public static void replace(IAttachmentHolder holder, Holder<Statistic> stat, long amount, LongBinaryOperator replacer) {
        StatisticTracker.replace(holder, (Statistic)stat.value(), amount, replacer);
    }

    public static void replace(IAttachmentHolder holder, Statistic statistic, long amount, LongBinaryOperator replacer) {
        StatisticTracker tracker = (StatisticTracker)holder.getData(CoreDataAttachments.STATISTICS);
        long existing = tracker.get(statistic);
        long newValue = replacer.applyAsLong(existing, amount);
        tracker.set(statistic, newValue);
        if (holder instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)holder;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.STATISTICS.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean replaceOptional(IAttachmentHolder holder, Holder<Statistic> stat, long amount, LongBinaryOperator replacer) {
        return StatisticTracker.replaceOptional(holder, (Statistic)stat.value(), amount, replacer);
    }

    public static boolean replaceOptional(IAttachmentHolder holder, Statistic statistic, long amount, LongBinaryOperator replacer) {
        if (holder.hasData(CoreDataAttachments.STATISTICS)) {
            StatisticTracker.replace(holder, statistic, amount, replacer);
            return true;
        }
        return false;
    }

    public long get(Statistic stat) {
        return this.stats.getLong((Object)stat);
    }

    public void increment(Statistic stat) {
        this.increment(stat, 1L);
    }

    public void increment(Statistic stat, long amount) {
        this.set(stat, this.get(stat) + amount);
    }

    public void set(Statistic stat, long amount) {
        this.stats.put((Object)stat, Math.clamp(amount, 0L, Long.MAX_VALUE));
    }

    public void resetStatistics() {
        this.stats.clear();
    }

    @Override
    public Codec<StatisticTracker> networkCodec() {
        return CODEC;
    }
}

