/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.mixin;

import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILivingEntityExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.common.energy.EnergySystem;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements Attackable,
ILivingEntityExtension {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setSprinting"}, at={@At(value="HEAD")}, cancellable=true)
    private void tarkovCraftCore$setSprinting(boolean sprinting, CallbackInfo ci) {
        if (!sprinting) {
            return;
        }
        LivingEntity entity = (LivingEntity)this;
        MovementStaminaComponent component = EnergySystem.MOVEMENT_STAMINA.getComponent();
        if (!component.canSprint(entity)) {
            ci.cancel();
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")}, cancellable=true)
    private void tarkovCraftCore$jumpFromGround(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        MovementStaminaComponent component = EnergySystem.MOVEMENT_STAMINA.getComponent();
        if (component.canJump(entity)) {
            component.onJump(entity);
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tarkovCraftCore$tick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        MovementStaminaComponent component = EnergySystem.MOVEMENT_STAMINA.getComponent();
        component.tick(entity);
    }
}

