/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.network.message.mail;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.mail.MailList;
import tnt.tarkovcraft.core.common.mail.MailManager;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailMessageAttachment;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.common.mail.MailSystem;
import tnt.tarkovcraft.core.network.TarkovCraftCoreNetwork;

public record C2S_MailClaimAttachments(UUID chatId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = TarkovCraftCoreNetwork.createId(C2S_MailClaimAttachments.class);
    public static final CustomPacketPayload.Type<C2S_MailClaimAttachments> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<ByteBuf, C2S_MailClaimAttachments> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2S_MailClaimAttachments::chatId, C2S_MailClaimAttachments::new);

    public void handleMessage(IPayloadContext context) {
        Player player = context.player();
        MailManager mailManager = (MailManager)player.getData(CoreDataAttachments.MAIL_MANAGER);
        MailSource source = mailManager.getSender(this.chatId());
        if (source != null) {
            MailList chat = mailManager.getChat(source);
            List<MailMessage> messages = chat.listMessages();
            Iterator<MailMessage> iterator = messages.iterator();
            boolean claiming = true;
            while (iterator.hasNext() && claiming) {
                MailMessage message = iterator.next();
                if (message.isExpired()) {
                    TarkovCraftCore.LOGGER.debug(MailSystem.MARKER, "Removing expired message {} from player {}", (Object)message.getMessageId(), (Object)player.getName().getString());
                    iterator.remove();
                }
                Map<UUID, MailMessageAttachment> attachments = message.listAttachments();
                HashSet<UUID> claimedAttachments = new HashSet<UUID>();
                for (Map.Entry<UUID, MailMessageAttachment> entry : attachments.entrySet()) {
                    UUID attachmentId = entry.getKey();
                    MailMessageAttachment attachment = entry.getValue();
                    if (!attachment.isClaimable(message, attachmentId, player)) continue;
                    TarkovCraftCore.LOGGER.debug(MailSystem.MARKER, "User {} is claiming attachment {} with content {}", (Object)player.getName().getString(), (Object)attachmentId, (Object)attachment);
                    boolean canClaimNext = attachment.claim(message, attachmentId, player);
                    claimedAttachments.add(attachmentId);
                    if (canClaimNext) continue;
                    claiming = false;
                    break;
                }
                claimedAttachments.forEach(message::removeAttachment);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

