/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen;

import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.joml.Vector2f;
import org.joml.Vector4f;
import tnt.tarkovcraft.core.client.screen.CharacterSubScreen;
import tnt.tarkovcraft.core.client.screen.SharedScreenState;
import tnt.tarkovcraft.core.client.screen.TooltipHelper;
import tnt.tarkovcraft.core.client.screen.renderable.ShapeRenderable;
import tnt.tarkovcraft.core.client.screen.widget.ListWidget;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartHealthWidget;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartWidget;
import tnt.tarkovcraft.medsystem.common.effect.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;

public class HealthScreen
extends CharacterSubScreen {
    private double bodyPartScroll;

    public HealthScreen(Context context) {
        super((UUID)context.getOrThrow(ContextKeys.UUID), MedicalSystemClient.HEALTH);
    }

    protected void init() {
        super.init();
        this.addRenderableOnly((Renderable)new ShapeRenderable(0, 25, this.width, this.height - 25, 0x44000000));
        HealthContainer container = (HealthContainer)this.minecraft.player.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        HealthContainerDefinition definition = container.getDefinition();
        List<BodyPartDisplay> displays = definition.getDisplayConfiguration();
        Vector2f center = new Vector2f((float)this.width / 6.0f, (float)this.height / 2.0f);
        int left = this.width / 3 - 15;
        SharedScreenState state = new SharedScreenState();
        ListWidget list = (ListWidget)this.addRenderableWidget((GuiEventListener)new ListWidget(left, 35, this.width - left, this.height - 35, displays, (display, index) -> this.createBodyPartWidget((BodyPartDisplay)display, container, index, (SharedScreenState<BodyPart>)state)));
        list.setAdditionalItemSpacing(4);
        list.setScroll(this.bodyPartScroll);
        list.setScrollListener((x, y) -> {
            this.bodyPartScroll = y;
        });
        for (BodyPartDisplay display2 : displays) {
            String name = display2.source();
            BodyPart part = container.getBodyPart(name);
            if (part == null) {
                return;
            }
            Vector4f pos = display2.getGuiPosition(1.5f, center);
            BodyPartWidget bodyPartWidget = (BodyPartWidget)this.addRenderableOnly((Renderable)new BodyPartWidget((int)pos.x, (int)pos.y, (int)pos.z, (int)pos.w, part));
            bodyPartWidget.setScale(3);
            bodyPartWidget.setTooltip(Tooltip.create((Component)part.getDisplayName()));
            bodyPartWidget.setTooltipDelay(Duration.ofMillis(500L));
            bodyPartWidget.setHoverState((SharedScreenState<BodyPart>)state);
        }
    }

    private BodyPartHealthWidget createBodyPartWidget(BodyPartDisplay display, HealthContainer container, int index, SharedScreenState<BodyPart> state) {
        int left = this.width / 3 - 15;
        BodyPart part = container.getBodyPart(display.source());
        Stream<StatusEffect> stream = part.getStatusEffects().getEffectsStream();
        if (container.getRootBodyPart().getName().equals(part.getName())) {
            stream = Stream.concat(container.getGlobalStatusEffects().getEffectsStream(), stream);
        }
        BodyPartHealthWidget widget = new BodyPartHealthWidget(left, index * 40, 125, 36, this.font, part);
        List<StatusEffect> effects = stream.filter(ef -> ef.isActive() && ef.getType().getVisibility().isVisibleInMode(EffectVisibility.UI)).toList();
        widget.setEffects(effects, TooltipHelper.screen((Screen)this));
        widget.setHealthScale(10.0f);
        widget.setHoverState(state);
        return widget;
    }
}

