/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.reaction.ReactionDefinition;

public final class BodyPartDefinition {
    public static final Codec<BodyPartDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("vital", (Object)false).forGetter(t -> t.vital), (App)Codec.STRING.optionalFieldOf("parent").forGetter(t -> Optional.ofNullable(t.parent)), (App)Codec.floatRange((float)0.0f, (float)10.0f).optionalFieldOf("parentDamageScale", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.parentDamageScale)), (App)Codec.floatRange((float)0.0f, (float)10.0f).optionalFieldOf("damageScale", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.damageScale)), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("health").forGetter(t -> Float.valueOf(t.maxHealth)), (App)Codecs.enumCodec(BodyPartGroup.class).optionalFieldOf("group", (Object)BodyPartGroup.OTHER).forGetter(t -> t.bodyPartGroup), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, ReactionDefinition.CODEC).optionalFieldOf("reactions", Collections.emptyMap()).forGetter(t -> t.reactions)).apply((Applicative)instance, BodyPartDefinition::new));
    private final boolean vital;
    @Nullable
    private final String parent;
    private final float parentDamageScale;
    private final float damageScale;
    private final float maxHealth;
    private final BodyPartGroup bodyPartGroup;
    private final Map<UUID, ReactionDefinition> reactions;

    public BodyPartDefinition(boolean vital, Optional<String> parent, float parentDamageScale, float damageScale, float maxHealth, BodyPartGroup bodyPartGroup, Map<UUID, ReactionDefinition> reactions) {
        this.vital = vital;
        this.parent = parent.orElse(null);
        this.parentDamageScale = parentDamageScale;
        this.damageScale = damageScale;
        this.maxHealth = maxHealth;
        this.bodyPartGroup = bodyPartGroup;
        this.reactions = reactions;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    public boolean isVital() {
        return this.vital;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getParentDamageScale() {
        return this.parentDamageScale;
    }

    public float getDamageScale() {
        return this.damageScale;
    }

    public BodyPart createContainer(String key) {
        BodyPart part = new BodyPart(key, this.vital, this.maxHealth, this.parentDamageScale, this.damageScale, this.bodyPartGroup);
        part.setDefinition(this);
        return part;
    }

    public Collection<ReactionDefinition> getReactions() {
        return this.reactions.values();
    }

    Map<UUID, ReactionDefinition> getReactionMap() {
        return this.reactions;
    }

    public BodyPartGroup getBodyPartGroup() {
        return this.bodyPartGroup;
    }
}

