/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.common.MedicalSystemContextKeys;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.reaction.ChanceHealthEventSource;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSourceType;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunction;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHealthReactions;

public class DamageSourceHealthEventSource
extends ChanceHealthEventSource {
    public static final MapCodec<DamageSourceHealthEventSource> CODEC = RecordCodecBuilder.mapCodec(instance -> DamageSourceHealthEventSource.common(instance).and((App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("source").forGetter(t -> t.damageType)).apply((Applicative)instance, DamageSourceHealthEventSource::new));
    private final TagKey<DamageType> damageType;

    public DamageSourceHealthEventSource(float baseChance, List<ChanceFunction> functions, TagKey<DamageType> damageType) {
        super(baseChance, functions);
        this.damageType = damageType;
    }

    @Override
    public boolean canReact(Context context) {
        BodyPart part = (BodyPart)context.getOrDefault(MedicalSystemContextKeys.BODY_PART, null);
        if (part == null) {
            return false;
        }
        return context.get(ContextKeys.DAMAGE_SOURCE).map(source -> {
            if (!source.is(this.damageType)) {
                return false;
            }
            return super.canReact(context);
        }).orElse(false);
    }

    @Override
    public HealthEventSourceType<?> getType() {
        return MedSystemHealthReactions.DAMAGE_SOURCE.get();
    }
}

