/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSource;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSourceType;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEvent;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEventType;

public record ReactionDefinition(HealthEventSource reaction, List<HealthSourceEvent> responses) {
    public static final Codec<ReactionDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HealthEventSourceType.CODEC.fieldOf("source").forGetter(ReactionDefinition::reaction), (App)Codecs.list(HealthSourceEventType.CODEC).fieldOf("events").forGetter(ReactionDefinition::responses)).apply((Applicative)instance, ReactionDefinition::new));

    public void react(Context context) {
        Player player;
        boolean noEffects;
        MedSystemConfig config = MedicalSystem.getConfig();
        LivingEntity entity = (LivingEntity)context.getOrThrow(ContextKeys.LIVING_ENTITY);
        boolean bl = noEffects = entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator());
        if (config.enableHitEffects && this.reaction.canReact(context) && !noEffects) {
            this.responses.forEach(resp -> resp.onReactionPassed(this.reaction, context));
        }
    }
}

