/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunction;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunctionType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemChanceFunctions;

public class FallDistanceScaleFunction
implements ChanceFunction {
    public static final MapCodec<FallDistanceScaleFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.scale))).apply((Applicative)instance, FallDistanceScaleFunction::new));
    private final float scale;

    public FallDistanceScaleFunction(float scale) {
        this.scale = scale;
    }

    @Override
    public float apply(float chance, Context context) {
        return context.get(ContextKeys.LIVING_ENTITY).map(entity -> {
            double distance = entity.fallDistance;
            return Float.valueOf((float)(distance * (double)this.scale) * chance);
        }).orElse(Float.valueOf(chance)).floatValue();
    }

    @Override
    public ChanceFunctionType<?> getType() {
        return MedSystemChanceFunctions.FALL_DISTANCE.get();
    }
}

