/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.notification;

import com.mojang.blaze3d.platform.Window;
import java.util.Deque;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.client.notification.ClientNotification;
import tnt.tarkovcraft.core.client.notification.NotificationChannel;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class NotificationLayer
implements LayeredDraw.Layer {
    public static final ResourceLocation LAYER_ID = TarkovCraftCore.createResourceLocation("layer/notification");
    public static final int NOTIFICATION_Z_LAYER = 1000;
    public static final IntUnaryOperator DEFAULT_NOTIFICATION_WIDTH = w -> Mth.ceil((float)((float)w * 0.45f));
    private final NotificationChannel channel;

    public NotificationLayer(NotificationChannel channel) {
        this.channel = channel;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        Font font = minecraft.font;
        int windowWidth = window.getGuiScaledWidth();
        NotificationLayer.drawNotifications(guiGraphics, font, windowWidth, window.getGuiScaledHeight(), this.channel, DEFAULT_NOTIFICATION_WIDTH.applyAsInt(windowWidth));
    }

    public static void drawNotifications(GuiGraphics graphics, Font font, int windowWidth, int windowHeight, NotificationChannel channel, int maxWidth) {
        Deque<ClientNotification> notifications = channel.getNotifications();
        if (notifications.isEmpty()) {
            return;
        }
        int y = windowHeight - 11;
        int left = windowWidth - maxWidth;
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 1000.0f);
        for (ClientNotification notification : notifications) {
            graphics.fill(left, y, windowWidth, y + 10, 0x66000000);
            RenderUtils.blitFull(graphics, notification.icon(), left, y, left + 10, y + 10);
            graphics.drawScrollingString(font, notification.label(), left + 12, windowWidth, y + 1, 0xFFFFFF);
            y -= 11;
        }
        graphics.pose().popPose();
    }
}

