/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.core.api.event.client.GetPlayerLabelsEvent;
import tnt.tarkovcraft.core.client.screen.CharacterSubScreen;
import tnt.tarkovcraft.core.client.screen.navigation.CoreNavigators;
import tnt.tarkovcraft.core.client.screen.renderable.AbstractTextRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.HorizontalLineRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.ShapeRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.VerticalLineRenderable;
import tnt.tarkovcraft.core.client.screen.widget.EntityWidget;
import tnt.tarkovcraft.core.client.screen.widget.ListWidget;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.init.CoreStatistics;
import tnt.tarkovcraft.core.common.statistic.DisplayStatistic;
import tnt.tarkovcraft.core.common.statistic.Statistic;
import tnt.tarkovcraft.core.common.statistic.StatisticTracker;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextImpl;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.core.util.helper.RenderUtils;
import tnt.tarkovcraft.core.util.helper.TextHelper;

public class StatisticsScreen
extends CharacterSubScreen {
    public static final Component OVERVIEW_LABEL = TextHelper.createScreenComponent("tarkovcraft_core", "statistics", "overview").withStyle(ChatFormatting.BOLD);
    private double textScroll;

    public StatisticsScreen(Context context) {
        super(context.getOrThrow(ContextKeys.UUID), CoreNavigators.STATISTICS_ENTRY);
    }

    @Override
    protected void init() {
        super.init();
        this.getPlayer().ifPresent(player -> {
            int left = this.width / 3;
            EntityWidget entityWidget = (EntityWidget)this.addRenderableWidget((GuiEventListener)new EntityWidget(0, 25, left, this.height - 25, (LivingEntity)player));
            entityWidget.setBackground(0x44000000);
            entityWidget.setOffset(0.0f, -0.4f, 0.0f);
            StatisticTracker tracker = (StatisticTracker)player.getData(CoreDataAttachments.STATISTICS);
            RegistryAccess access = player.level().registryAccess();
            Registry registry = access.lookupOrThrow(CoreRegistries.DatapackKeys.DISPLAY_STATISTIC);
            List<DisplayStatistic> statistics = registry.listElements().map(Holder.Reference::value).sorted(Comparator.comparingInt(DisplayStatistic::getOrder)).toList();
            ContextImpl context = ContextImpl.of(StatisticTracker.TRACKER, tracker);
            this.addRenderableOnly(new ShapeRenderable(left, 25, this.width - left, 10, 0x44000000));
            this.addRenderableOnly(new HorizontalLineRenderable(left, this.width, 35, -1));
            this.addRenderableOnly(new VerticalLineRenderable(left - 1, 25, this.height, -1));
            this.addRenderableOnly(new AbstractTextRenderable.Component(left + 3, 26, this.width - left, 10, -1, true, this.font, OVERVIEW_LABEL));
            List<Component> playerLabels = this.getPlayerLabels((Player)player, tracker);
            int top = this.height - 20 - playerLabels.size() * 12;
            for (int i = 0; i < playerLabels.size(); ++i) {
                Component playerLabel = playerLabels.get(i);
                this.addRenderableOnly(new AbstractTextRenderable.CenteredComponent(0, top + i * 12, left, 10, 0xFFFFFF, true, this.font, playerLabel));
            }
            ListWidget textStats = (ListWidget)this.addRenderableWidget((GuiEventListener)new ListWidget<TextStatisticWidget>(left, 36, this.width - left, this.height - 26, statistics, (it, in) -> this.createTextStatistic(left, this.width - left, context, (DisplayStatistic)it, in)));
            textStats.setBackgroundColor(0x44000000);
            textStats.setScroll(this.textScroll);
            textStats.setScrollListener((x, y) -> {
                this.textScroll = y;
            });
        });
    }

    private List<Component> getPlayerLabels(Player player, StatisticTracker tracker) {
        ArrayList<Component> playerLabels = new ArrayList<Component>();
        playerLabels.add((Component)player.getDisplayName().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}));
        long kills = tracker.get((Statistic)CoreStatistics.PLAYER_KILLS.value());
        long deaths = Math.max(tracker.get((Statistic)CoreStatistics.PLAYER_DEATHS.value()), 1L);
        float kdr = (float)kills / (float)deaths;
        String kdrLabel = String.format(Locale.ROOT, "%.2f", Float.valueOf(kdr));
        MutableComponent kdrComponent = Component.literal((String)kdrLabel);
        playerLabels.add((Component)Component.translatable((String)"label.tarkovcraft_core.kdr", (Object[])new Object[]{kdrComponent}).withStyle(ChatFormatting.GRAY));
        GetPlayerLabelsEvent event = (GetPlayerLabelsEvent)NeoForge.EVENT_BUS.post((Event)new GetPlayerLabelsEvent(player, playerLabels));
        return event.getLabelList();
    }

    private TextStatisticWidget createTextStatistic(int left, int width, Context ctx, DisplayStatistic stat, int index) {
        TextStatisticWidget widget = new TextStatisticWidget(left, index * 10, width, 10, this.font, ctx, stat);
        widget.setBackground(index % 2 != 0 ? 0x22000000 : 0x44000000);
        return widget;
    }

    public static final class TextStatisticWidget
    extends AbstractWidget {
        private final Font font;
        private final Context context;
        private final DisplayStatistic statistic;
        private int background;

        public TextStatisticWidget(int x, int y, int width, int height, Font font, Context context, DisplayStatistic statistic) {
            super(x, y, width, height, statistic.getLabel());
            this.font = font;
            this.context = context;
            this.statistic = statistic;
        }

        public void setBackground(int background) {
            this.background = background;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            if (RenderUtils.isVisibleColor(this.background)) {
                graphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), this.background);
            }
            graphics.drawString(this.font, this.getMessage(), this.getX() + 3, this.getY() + 1, 0xE0E0E0, true);
            String value = this.statistic.get(this.context);
            graphics.drawString(this.font, value, this.getRight() - this.font.width(value) - 3, this.getY() + 1, -256, true);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

