/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.FormattedText;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class LabelButton
extends Button {
    private int backgroundColor = 0;
    private int backgroundDisabledColor = 0;
    private int backgroundHoverColor = 0x44FFFFFF;
    private int color = 0xE0E0E0;
    private int colorDisabled = 0x707070;
    private int colorSelected = -1;

    public LabelButton(Button.Builder builder) {
        super(builder);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorDisabled(int colorDisabled) {
        this.colorDisabled = colorDisabled;
    }

    public void setColorSelected(int colorSelected) {
        this.colorSelected = colorSelected;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackgroundDisabledColor(int backgroundDisabledColor) {
        this.backgroundDisabledColor = backgroundDisabledColor;
    }

    public void setBackgroundHoverColor(int backgroundHoverColor) {
        this.backgroundHoverColor = backgroundHoverColor;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float renderTick) {
        int background;
        Font font = Minecraft.getInstance().font;
        int n = this.isActive() ? (this.isHoveredOrFocused() ? this.backgroundHoverColor : this.backgroundColor) : (background = this.backgroundDisabledColor);
        if (RenderUtils.isVisibleColor(background)) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), background);
        }
        int color = this.isActive() ? (this.isHoveredOrFocused() ? this.colorSelected : this.color) : this.colorDisabled;
        String string = this.getMessage().getString();
        float f = (float)this.getX() + (float)(this.getWidth() - font.width((FormattedText)this.getMessage())) / 2.0f;
        float f2 = this.getY();
        int n2 = this.getHeight();
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, string, f, f2 + (float)(n2 - 9) / 2.0f, color, false);
    }
}

