/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.Entity;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.AttributeListener;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.common.init.CoreRegistries;

public final class AttributeInstance {
    public static final Codec<AttributeInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CoreRegistries.ATTRIBUTE.byNameCodec().fieldOf("attribute").forGetter(AttributeInstance::getAttribute), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, AttributeModifier.CODEC).fieldOf("modifiers").forGetter(t -> t.modifiers)).apply((Applicative)instance, AttributeInstance::new));
    private Entity holder;
    private final Attribute attribute;
    private final Map<UUID, AttributeModifier> modifiers;
    private final List<AttributeListener> listeners;
    private double value;
    private boolean changed;

    AttributeInstance(Attribute attribute, Entity holder) {
        this.attribute = attribute;
        this.holder = holder;
        this.modifiers = new HashMap<UUID, AttributeModifier>();
        this.listeners = new ArrayList<AttributeListener>();
        this.value = this.attribute.getBaseValue();
        this.changed = true;
    }

    AttributeInstance(Attribute attribute, Map<UUID, AttributeModifier> modifiers) {
        this.attribute = attribute;
        this.modifiers = new HashMap<UUID, AttributeModifier>(modifiers);
        this.listeners = new ArrayList<AttributeListener>();
        this.value = this.attribute.getBaseValue();
        this.changed = true;
    }

    public void setHolder(Entity holder) {
        this.holder = holder;
    }

    public Entity getHolder() {
        return this.holder;
    }

    public void update() {
        Iterator<AttributeModifier> iterator = this.modifiers.values().iterator();
        while (iterator.hasNext()) {
            AttributeModifier modifier = iterator.next();
            boolean shouldRemoveModifier = modifier.onCancellationTick(this);
            if (!shouldRemoveModifier) continue;
            iterator.remove();
            this.invokeEvent(t -> t.onAttributeModifierRemoved(this, modifier));
            this.setChanged();
        }
    }

    public void addModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.identifier(), modifier);
        this.invokeEvent(t -> t.onAttributeModifierAdded(this, modifier));
        this.setChanged();
    }

    public void removeModifier(AttributeModifier modifier) {
        this.removeModifier(modifier.identifier());
    }

    public void removeModifier(UUID identifier) {
        AttributeModifier modifier = this.modifiers.remove(identifier);
        if (modifier != null) {
            this.invokeEvent(t -> t.onAttributeModifierRemoved(this, modifier));
            this.setChanged();
        }
    }

    public void removeModifiers() {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>(this.modifiers.values());
        this.modifiers.clear();
        modifiers.forEach(mod -> this.invokeEvent(t -> t.onAttributeModifierRemoved(this, (AttributeModifier)mod)));
        this.setChanged();
    }

    public boolean hasModifier(UUID identifier) {
        return this.modifiers.containsKey(identifier);
    }

    public boolean hasModifier(AttributeModifier modifier) {
        return this.hasModifier(modifier.identifier());
    }

    public void addListener(AttributeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AttributeListener listener) {
        this.listeners.remove(listener);
    }

    public int getActiveListenerCount() {
        return this.listeners.size();
    }

    public Map<UUID, AttributeModifier> listModifiers() {
        return this.modifiers;
    }

    public double value() {
        if (this.changed) {
            this.refreshValue();
            this.changed = false;
        }
        return this.value;
    }

    public float floatValue() {
        return (float)this.value();
    }

    public int intValue() {
        return (int)this.value();
    }

    public boolean booleanValue() {
        return this.value() != 0.0;
    }

    public void setChanged() {
        if (!this.changed) {
            this.changed = true;
            this.invokeEvent(t -> t.onAttributeSetChanged(this));
        }
    }

    public void invokeEvent(Consumer<AttributeListener> event) {
        this.listeners.forEach(event);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    private void refreshValue() {
        double result = this.attribute.getBaseValue();
        ArrayList<AttributeModifier> modifierList = new ArrayList<AttributeModifier>(this.modifiers.values());
        modifierList.sort(Comparator.comparingInt(AttributeModifier::ordering));
        for (AttributeModifier modifier : modifierList) {
            result = modifier.calculateValue(this, result);
        }
        if (this.value != result) {
            double oldValue = this.value;
            this.value = result;
            this.invokeEvent(t -> t.onAttributeValueChanged(this, oldValue));
        }
    }
}

