/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.stat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.attribute.modifier.AddValueModifier;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.init.CoreSkillStats;
import tnt.tarkovcraft.core.common.skill.Skill;
import tnt.tarkovcraft.core.common.skill.SkillContextKeys;
import tnt.tarkovcraft.core.common.skill.stat.SkillStat;
import tnt.tarkovcraft.core.common.skill.stat.SkillStatType;
import tnt.tarkovcraft.core.util.UnitFormat;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;

public class AddAttributeModifierStat
implements SkillStat {
    public static final MapCodec<AddAttributeModifierStat> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CoreRegistries.ATTRIBUTE.byNameCodec().fieldOf("attribute").forGetter(t -> t.target), (App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(t -> t.id), (App)Codec.FLOAT.fieldOf("levelValue").forGetter(t -> Float.valueOf(t.levelValue)), (App)Codec.BOOL.optionalFieldOf("constant", (Object)false).forGetter(t -> t.constant), (App)UnitFormat.CODEC.optionalFieldOf("displayUnitFormat", (Object)UnitFormat.IDENTITY).forGetter(t -> t.displayUnitFormat)).apply((Applicative)instance, AddAttributeModifierStat::new));
    private final Attribute target;
    private final UUID id;
    private final float levelValue;
    private final boolean constant;
    private final UnitFormat displayUnitFormat;

    public AddAttributeModifierStat(Attribute target, UUID id, float levelValue, boolean constant, UnitFormat displayUnitFormat) {
        this.target = target;
        this.id = id;
        this.levelValue = levelValue;
        this.constant = constant;
        this.displayUnitFormat = displayUnitFormat;
    }

    @Override
    public void clear(Context context) {
        context.get(ContextKeys.ENTITY).ifPresent(entity -> {
            if (entity.hasData(CoreDataAttachments.ENTITY_ATTRIBUTES)) {
                EntityAttributeData attributes = (EntityAttributeData)entity.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
                attributes.getAttribute(this.target).removeModifier(this.id);
            }
        });
    }

    @Override
    public void apply(Context context) {
        context.get(ContextKeys.ENTITY).ifPresent(entity -> {
            int skillLevel = context.get(SkillContextKeys.SKILL).map(Skill::getLevel).orElse(0);
            EntityAttributeData attributes = (EntityAttributeData)entity.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
            AttributeInstance instance = attributes.getAttribute(this.target);
            AddValueModifier modifier = new AddValueModifier(this.id, this.constant ? (double)this.levelValue : (double)((float)skillLevel * this.levelValue));
            instance.addModifier(modifier);
        });
    }

    @Override
    public Object[] getTranslationData(Context context) {
        int skillLevel = context.get(SkillContextKeys.SKILL).map(Skill::getLevel).orElse(0);
        double value = this.constant ? (double)this.levelValue : (double)((float)skillLevel * this.levelValue);
        MutableComponent label = Component.literal((String)this.displayUnitFormat.format(value)).withStyle(ChatFormatting.GREEN);
        return new Object[]{label};
    }

    @Override
    public SkillStatType<?> getType() {
        return CoreSkillStats.ADD_MODIFIER.get();
    }
}

